/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Consumer;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.util.data.Fertilizer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public interface IFarmland {
    public static final float WATER_DISSIPATION_RATE = 0.001f;

    public static void addNutrientParticles(ServerLevel level, BlockPos pos, Fertilizer fertilizer) {
        int i;
        float n = fertilizer.nitrogen();
        float p = fertilizer.phosphorus();
        float k = fertilizer.potassium();
        for (i = 0; i < (int)(n > 0.0f ? Mth.clamp((float)(n * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.NITROGEN.get()), (double)((float)pos.getX() + level.random.nextFloat()), (double)pos.getY() + (double)level.random.nextFloat() / 5.0, (double)((float)pos.getZ() + level.random.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(p > 0.0f ? Mth.clamp((float)(p * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.PHOSPHORUS.get()), (double)((float)pos.getX() + level.random.nextFloat()), (double)pos.getY() + (double)level.random.nextFloat() / 5.0, (double)((float)pos.getZ() + level.random.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(k > 0.0f ? Mth.clamp((float)(k * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.POTASSIUM.get()), (double)((float)pos.getX() + level.random.nextFloat()), (double)pos.getY() + (double)level.random.nextFloat() / 5.0, (double)((float)pos.getZ() + level.random.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public float getNutrient(FarmlandBlockEntity.NutrientType var1);

    public void setNutrient(FarmlandBlockEntity.NutrientType var1, float var2);

    public void setNutrientWithoutSync(FarmlandBlockEntity.NutrientType var1, float var2);

    default public void addNutrient(FarmlandBlockEntity.NutrientType type, float value) {
        this.setNutrient(type, this.getNutrient(type) + value);
    }

    default public void addNutrients(Fertilizer fertilizer) {
        this.addNutrients(fertilizer, 1.0f);
    }

    default public void addNutrients(Fertilizer fertilizer, float multiplier) {
        this.addNutrient(FarmlandBlockEntity.NutrientType.NITROGEN, fertilizer.nitrogen() * multiplier);
        this.addNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, fertilizer.phosphorus() * multiplier);
        this.addNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM, fertilizer.potassium() * multiplier);
    }

    public float getAdditionalWater();

    public void waterTick();

    public void setAdditionalWater(float var1);

    public void setAdditionalWaterWithoutSync(float var1);

    default public void addAdditionalWater(float additionalWater) {
        this.setAdditionalWater(this.getAdditionalWater() + additionalWater);
    }

    public long getLastWaterTick();

    public void setLastWaterTick(long var1);

    default public float consumeNutrients(float amount, FarmlandBlockEntity.NutrientType type) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float startValue = this.getNutrient(type);
        float consumed = Math.min(startValue, amount);
        this.setNutrient(type, startValue - consumed);
        return consumed;
    }

    default public void produceNutrients(float amount, FarmlandBlockEntity.NutrientType type, float percentOtherNutrientsConsumed, float growthDelta) {
        if (amount <= 0.0f) {
            amount = -(0.3f + 0.7f * percentOtherNutrientsConsumed) * amount * growthDelta;
            this.addNutrient(type, amount);
        }
    }

    default public boolean isMaxedOut() {
        return this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN) == 1.0f && this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS) == 1.0f && this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM) == 1.0f;
    }

    default public void updateAdditionalWater(long fromTick, long toTick) {
        long deltaTicks = toTick - fromTick;
        this.addAdditionalWater((float)deltaTicks * 0.001f);
    }

    default public void saveNutrients(CompoundTag nbt) {
        nbt.putFloat("n", this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN));
        nbt.putFloat("p", this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS));
        nbt.putFloat("k", this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM));
    }

    default public void loadNutrients(CompoundTag nbt) {
        this.setNutrient(FarmlandBlockEntity.NutrientType.NITROGEN, nbt.getFloat("n"));
        this.setNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, nbt.getFloat("p"));
        this.setNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM, nbt.getFloat("k"));
    }

    default public void loadNutrientsWithoutSync(CompoundTag nbt) {
        this.setNutrientWithoutSync(FarmlandBlockEntity.NutrientType.NITROGEN, nbt.getFloat("n"));
        this.setNutrientWithoutSync(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, nbt.getFloat("p"));
        this.setNutrientWithoutSync(FarmlandBlockEntity.NutrientType.POTASSIUM, nbt.getFloat("k"));
    }

    default public void loadAdditionalWaterWithoutSync(CompoundTag nbt) {
        this.setAdditionalWaterWithoutSync(nbt.getFloat("water"));
    }

    default public void saveAdditionalWater(CompoundTag nbt) {
        nbt.putFloat("water", this.getAdditionalWater());
    }

    default public void addTooltipInfo(Consumer<Component> text) {
        text.accept((Component)Component.translatable((String)"tfc.tooltip.farmland.nutrients", (Object[])new Object[]{this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN)), this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS)), this.format(this.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM))}));
    }

    private String format(float value) {
        return String.format("%.2f", Float.valueOf(value * 100.0f));
    }
}

