/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Objects;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends TFCBlockEntity
implements ISlotCallback,
MenuProvider,
Clearable {
    protected final C inventory;
    protected final SidedHandler<IItemHandlerModifiable> sidedInventory;
    @Nullable
    protected Component customName;
    protected final Component defaultName;

    public static InventoryFactory<ItemStackHandler> defaultInventory(int slots) {
        return self -> new InventoryItemHandler(self, slots);
    }

    protected InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryFactory<C> inventoryFactory) {
        this(type, pos, state, inventoryFactory, "tfc");
    }

    protected InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryFactory<C> inventoryFactory, String modId) {
        super(type, pos, state);
        this.inventory = inventoryFactory.create(this);
        this.sidedInventory = new SidedHandler<C>(this.inventory);
        this.defaultName = Component.translatable((String)(modId + ".block_entity." + Objects.requireNonNull(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(type)).getPath()));
    }

    public C getInventory() {
        return this.inventory;
    }

    @Nullable
    public IItemHandler getSidedInventory(@Nullable Direction context) {
        return (IItemHandler)this.sidedInventory.get(context);
    }

    public Component getDisplayName() {
        return this.customName == null ? this.defaultName : this.customName;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        this.customName = (Component)components.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return null;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("CustomName")) {
            this.customName = InventoryBlockEntity.parseCustomNameSafe((String)nbt.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        ((INBTSerializable)this.inventory).deserializeNBT(provider, (Tag)nbt.getCompound("inventory"));
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.customName != null) {
            nbt.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        nbt.put("inventory", ((INBTSerializable)this.inventory).serializeNBT(provider));
        super.saveAdditional(nbt, provider);
    }

    public void clearContent() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void ejectInventory() {
        assert (this.level != null);
        for (ItemStack stack : Helpers.iterate(this.inventory)) {
            if (stack.isEmpty()) continue;
            Helpers.spawnItem(this.level, this.worldPosition, stack);
        }
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.setChanged();
    }

    public boolean canInteractWith(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @FunctionalInterface
    public static interface InventoryFactory<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>> {
        public C create(InventoryBlockEntity<C> var1);
    }
}

