/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LoomBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    private static final int SLOT_RECIPE = 0;
    private static final int SLOT_OUTPUT = 1;
    @Nullable
    private LoomRecipe recipe = null;
    @Nullable
    private ResourceLocation lastTexture;
    private int progress = 0;
    private long lastPushed = 0L;
    private boolean needsProgressUpdate = false;
    private boolean needsRecipeUpdate = false;

    public static void tick(Level level, BlockPos pos, BlockState state, LoomBlockEntity loom) {
        if (loom.needsRecipeUpdate) {
            loom.updateCachedRecipe();
            loom.needsRecipeUpdate = false;
        }
        if (!level.isClientSide) {
            loom.checkForLastTickSync();
        }
        if (loom.recipe != null) {
            if (loom.lastTexture == null) {
                loom.lastTexture = loom.recipe.getInProgressTexture();
            }
            LoomRecipe recipe = loom.recipe;
            if (loom.needsProgressUpdate && level.getGameTime() - loom.lastPushed >= 20L) {
                loom.needsProgressUpdate = false;
                ++loom.progress;
                if (loom.progress == recipe.getStepCount()) {
                    ((ItemStackHandler)loom.inventory).setStackInSlot(0, ItemStack.EMPTY);
                    ((ItemStackHandler)loom.inventory).setStackInSlot(1, recipe.assemble(((ItemStackHandler)loom.inventory).getStackInSlot(0)));
                }
                loom.markForSync();
            }
        }
    }

    public LoomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LOOM.get(), pos, state, LoomBlockEntity.defaultInventory(2));
        if (TFCConfig.SERVER.loomEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0), (Predicate<Direction>)Direction.Plane.HORIZONTAL);
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extract(1), Direction.DOWN);
        }
    }

    public ItemInteractionResult onRightClick(Player player) {
        assert (this.level != null);
        ItemStack heldItem = player.getMainHandItem();
        if (player.isShiftKeyDown()) {
            if (!((ItemStackHandler)this.inventory).getStackInSlot(0).isEmpty()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(0, Integer.MAX_VALUE, false));
                this.clearRecipe();
                this.markForSync();
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!((ItemStackHandler)this.inventory).getStackInSlot(1).isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).getStackInSlot(1).copy());
            ((ItemStackHandler)this.inventory).setStackInSlot(1, ItemStack.EMPTY);
            this.markForSync();
            this.clearRecipe();
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        ItemStack recipeItem = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (recipeItem.isEmpty() && this.isItemValid(0, heldItem)) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, heldItem.split(1));
            this.updateCachedRecipe();
            this.markForSync();
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (!recipeItem.isEmpty() && heldItem.getItem() == recipeItem.getItem() && this.recipe != null && this.recipe.getInputCount() > recipeItem.getCount()) {
            ((ItemStackHandler)this.inventory).getStackInSlot(0).grow(1);
            heldItem.shrink(1);
            this.markForSync();
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (this.recipe != null && heldItem.isEmpty() && this.recipe.getInputCount() == ((ItemStackHandler)this.inventory).getStackInSlot(0).getCount() && this.progress < this.recipe.getStepCount() && !this.needsProgressUpdate) {
            long time = this.level.getGameTime() - this.lastPushed;
            if (time <= 20L) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            this.level.playSound(null, this.worldPosition, (SoundEvent)TFCSounds.LOOM_WEAVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) / 16.0f);
            this.lastPushed = this.level.getGameTime();
            this.needsProgressUpdate = true;
            this.markForSync();
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean currentBoolean() {
        return this.progress % 2 == 0;
    }

    public int getCount() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0).getCount();
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public LoomRecipe getRecipe() {
        return this.recipe;
    }

    public double getAnimPos() {
        assert (this.level != null);
        if (this.recipe == null) {
            return 0.0;
        }
        int time = (int)(this.level.getGameTime() - this.lastPushed);
        if (time < 20) {
            return Math.sin(0.15707963267948966 * (double)time) * 0.23125;
        }
        return 0.0;
    }

    private void clearRecipe() {
        this.progress = 0;
        this.recipe = null;
        this.lastTexture = null;
        this.markForSync();
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsRecipeUpdate = true;
        this.markForSync();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.level != null);
        if (slot == 0) {
            if (!((ItemStackHandler)this.inventory).getStackInSlot(1).isEmpty()) {
                return false;
            }
            return LoomRecipe.getRecipe(stack) != null;
        }
        return true;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("progress", this.progress);
        if (this.lastTexture != null) {
            tag.putString("lastTexture", this.lastTexture.toString());
        }
        tag.putLong("lastPushed", this.lastPushed);
        super.saveAdditional(tag, provider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.progress = tag.getInt("progress");
        this.lastTexture = tag.contains("lastTexture", 8) ? Helpers.resourceLocation(tag.getString("lastTexture")) : null;
        this.needsRecipeUpdate = true;
        this.lastPushed = tag.getLong("lastPushed");
        super.loadAdditional(tag, provider);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        if (slot == 1) {
            return 64;
        }
        return this.recipe != null ? this.recipe.getInputCount() : 1;
    }

    @Nullable
    public ResourceLocation getLastTexture() {
        return this.lastTexture;
    }

    private void updateCachedRecipe() {
        assert (this.level != null);
        this.recipe = LoomRecipe.getRecipe(((ItemStackHandler)this.inventory).getStackInSlot(0));
        if (this.recipe == null && this.progress > 0) {
            this.progress = 0;
            this.markForSync();
        }
        if (((ItemStackHandler)this.inventory).getStackInSlot(1).isEmpty()) {
            this.lastTexture = null;
            this.markForSync();
        }
    }
}

