/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.ChannelBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.ItemCapabilities;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.heat.IHeatConsumer;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.FluidAlloy;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MoldBlockEntity
extends TickableInventoryBlockEntity<MoldBlockInventory> {
    private Optional<BlockPos> sourcePosition = Optional.empty();
    private Optional<Pair<Direction, Byte>> flowSource = Optional.empty();
    private Optional<Fluid> fluid = Optional.empty();
    private final SidedHandler<IFluidHandler> sidedFluidInventory = new SidedHandler<IFluidHandler>((IFluidHandler)this.inventory);
    public static final int MOLD_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;

    public static void serverTick(Level level, BlockPos pos, BlockState state, MoldBlockEntity mold) {
        CastingRecipe recipe;
        ItemStack drainStack;
        IMold moldItem;
        mold.checkForLastTickSync();
        if (!mold.getOutputStack().isEmpty()) {
            if (mold.hasSource()) {
                mold.finishFlow();
            }
            return;
        }
        if (mold.hasSource() && level.getGameTime() % 2L == 0L) {
            level.getBlockEntity(mold.sourcePosition.get(), (BlockEntityType)TFCBlockEntities.CRUCIBLE.get()).ifPresent(crucible -> {
                Optional<IFluidHandler> fluidHandler = MoldBlockEntity.getFluidHandlerIfAppropriate(crucible, mold.fluid);
                if (fluidHandler.isEmpty() || mold.isLinkBroken()) {
                    mold.finishFlow();
                    return;
                }
                FluidStack outputDrop = fluidHandler.get().drain(1, IFluidHandler.FluidAction.SIMULATE);
                FluidStack outputRemainder = Helpers.mergeOutputFluidIntoSlot(mold.getInventory(), outputDrop, crucible.getTemperature(), 0);
                Optional.ofNullable((IHeat)mold.getMoldStack().getCapability(ItemCapabilities.HEAT)).ifPresent(heatCap -> heatCap.setTemperature(crucible.getTemperature()));
                if (outputRemainder.isEmpty()) {
                    fluidHandler.get().drain(1, IFluidHandler.FluidAction.EXECUTE);
                    crucible.markForSync();
                    mold.markForSync();
                } else {
                    mold.finishFlow();
                }
            });
        }
        if ((moldItem = IMold.get(drainStack = ((MoldBlockInventory)mold.inventory).getStackInSlot(0))) != null && !moldItem.isMolten() && (recipe = CastingRecipe.get(moldItem)) != null) {
            Optional.ofNullable(recipe.assemble(moldItem)).ifPresent(stack -> {
                ((MoldBlockInventory)mold.inventory).setStackInSlot(1, (ItemStack)stack);
                moldItem.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            });
        }
    }

    public static Optional<IFluidHandler> getFluidHandlerIfAppropriate(CrucibleBlockEntity crucible, Optional<Fluid> shouldBeFluid) {
        IFluidHandler crucibleFluidHandler = crucible.getSidedFluidInventory(Direction.NORTH);
        FluidAlloy alloy = crucible.getAlloy();
        if (alloy == null) {
            return Optional.empty();
        }
        if (shouldBeFluid.isPresent() && alloy.getResult().getFluidType() != shouldBeFluid.get().getFluidType()) {
            return Optional.empty();
        }
        if (!((CrucibleBlockEntity.CrucibleInventory)crucible.getInventory()).isMolten()) {
            return Optional.empty();
        }
        return Optional.of(crucibleFluidHandler);
    }

    public MoldBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.MOLD_TABLE.get(), pos, state, MoldBlockInventory::new);
        this.sidedFluidInventory.on((IFluidHandler)((Function<IFluidHandler, IFluidHandler>)PartialFluidHandler::insertOnly), Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP);
        PartialItemHandler handler = new PartialItemHandler(this.inventory);
        this.sidedInventory.on(handler.insert(0), Direction.UP).on(handler.extract(1), Direction.DOWN);
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }

    public boolean hasSource() {
        return this.sourcePosition.isPresent();
    }

    public void finishFlow() {
        this.flowSource.ifPresent(flowSource -> {
            Direction expectedDirection = (Direction)flowSource.getLeft();
            byte expectedDistance = (Byte)flowSource.getRight();
            BlockPos expectedSourcePos = this.worldPosition.relative(expectedDirection, (int)expectedDistance);
            Optional channelBE = this.level.getBlockEntity(expectedSourcePos, (BlockEntityType)TFCBlockEntities.CHANNEL.get());
            channelBE.ifPresent(channel -> channel.notifyBrokenLink(1));
            this.markForSync();
            this.sourcePosition = Optional.empty();
            this.fluid = Optional.empty();
            this.flowSource = Optional.empty();
        });
    }

    public void setSource(BlockPos sourcePos, Fluid fluid, Pair<Direction, Byte> flowSource) {
        this.sourcePosition = Optional.of(sourcePos);
        this.fluid = Optional.of(fluid);
        this.flowSource = Optional.of(flowSource);
    }

    public boolean isLinkBroken() {
        Optional blockEntity = this.level.getBlockEntity(this.worldPosition.relative((Direction)this.flowSource.get().getLeft(), (int)((Byte)this.flowSource.get().getRight()).byteValue()), (BlockEntityType)TFCBlockEntities.CHANNEL.get());
        if (blockEntity.isEmpty()) {
            return true;
        }
        for (byte i = 1; i < (Byte)this.flowSource.get().getRight(); i = (byte)(i + 1)) {
            BlockPos rel = this.worldPosition.relative((Direction)this.flowSource.get().getLeft(), (int)i);
            if (this.level.getBlockState(rel).isAir()) continue;
            return true;
        }
        return ((ChannelBlockEntity)((Object)blockEntity.get())).isLinkBroken();
    }

    public Fluid getSourceFluid() {
        return this.fluid.get();
    }

    public Pair<Direction, Byte> getFlowSource() {
        return this.flowSource.get();
    }

    public ItemStack getMoldStack() {
        return ((MoldBlockInventory)this.inventory).getStackInSlot(0);
    }

    public ItemStack getOutputStack() {
        return ((MoldBlockInventory)this.inventory).getStackInSlot(1);
    }

    public void setMoldStack(ItemStack stack) {
        ((MoldBlockInventory)this.inventory).setStackInSlot(0, stack);
    }

    public void setOutputStack(ItemStack stack) {
        ((MoldBlockInventory)this.inventory).setStackInSlot(1, stack);
    }

    public ItemInteractionResult onRightClick(Player player) {
        boolean interactWithMoldSlot;
        boolean bl = interactWithMoldSlot = player.isShiftKeyDown() || ((MoldBlockInventory)this.inventory).getStackInSlot(0).isEmpty();
        if (interactWithMoldSlot) {
            boolean shouldInsert;
            ItemStack heldItem = player.getMainHandItem();
            boolean shouldExtract = !((MoldBlockInventory)this.inventory).getStackInSlot(0).isEmpty();
            boolean bl2 = shouldInsert = !heldItem.isEmpty() && this.isItemValid(0, heldItem);
            if (shouldExtract) {
                ItemStack extracted;
                if (shouldInsert) {
                    extracted = ((MoldBlockInventory)this.inventory).extractItem(0, 1, false);
                    ((MoldBlockInventory)this.inventory).insertItem(0, heldItem.split(1), false);
                    if (!this.level.isClientSide) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.getInventory().selected);
                    }
                } else if (!this.level.isClientSide) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((MoldBlockInventory)this.inventory).extractItem(0, 1, false), (int)player.getInventory().selected);
                }
                extracted = ((MoldBlockInventory)this.inventory).extractItem(1, 99, false);
                if (!this.level.isClientSide) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.getInventory().selected);
                }
                this.markForSync();
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            if (shouldInsert) {
                ((MoldBlockInventory)this.inventory).insertItem(0, heldItem.split(1), false);
                this.markForSync();
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
        } else {
            boolean shouldExtract;
            boolean bl3 = shouldExtract = !((MoldBlockInventory)this.inventory).getStackInSlot(1).isEmpty();
            if (shouldExtract) {
                if (!this.level.isClientSide) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((MoldBlockInventory)this.inventory).extractItem(1, 1, false), (int)player.getInventory().selected);
                }
                this.markForSync();
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return Helpers.isItem(stack, TFCTags.Items.USABLE_IN_MOLD_TABLE);
        }
        return true;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("sourcePosition")) {
            this.sourcePosition = Optional.of(BlockPos.of((long)nbt.getLong("sourcePosition")));
            this.flowSource = Optional.of(Pair.of((Object)Helpers.DIRECTIONS[nbt.getByte("flowSource")], (Object)(nbt.contains("flowSourceDistance") ? nbt.getByte("flowSourceDistance") : (byte)1)));
            this.fluid = Optional.of((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("fluid"))));
        } else {
            this.sourcePosition = Optional.empty();
            this.flowSource = Optional.empty();
            this.fluid = Optional.empty();
        }
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.hasSource()) {
            nbt.putLong("sourcePosition", this.sourcePosition.get().asLong());
            nbt.putByte("flowSource", (byte)((Direction)this.flowSource.get().getLeft()).ordinal());
            nbt.putByte("flowSourceDistance", ((Byte)this.flowSource.get().getRight()).byteValue());
            nbt.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)this.fluid.get()).toString());
        }
        super.saveAdditional(nbt, provider);
    }

    public void intakeAir(int amount) {
        ItemStack drainStack = ((MoldBlockInventory)this.inventory).getStackInSlot(0);
        Optional.ofNullable(IMold.get(drainStack)).ifPresent(moldItem -> moldItem.setTemperature(Math.max(0.0f, moldItem.getTemperature() - (float)(amount / 4))));
    }

    public static class MoldBlockInventory
    extends ItemStackHandler
    implements IFluidHandler,
    IHeatConsumer {
        private final MoldBlockEntity moldTable;

        MoldBlockInventory(InventoryBlockEntity<?> entity) {
            super(2);
            this.moldTable = (MoldBlockEntity)entity;
        }

        protected void onContentsChanged(int slot) {
            this.moldTable.markForSync();
        }

        private Optional<IFluidHandler> getMoldFluidHandler() {
            return Optional.ofNullable((IFluidHandler)this.moldTable.getMoldStack().getCapability(ItemCapabilities.FLUID));
        }

        private Optional<IHeat> getMoldHeatHandler() {
            return Optional.ofNullable((IHeat)this.moldTable.getMoldStack().getCapability(ItemCapabilities.HEAT));
        }

        @Override
        public float getTemperature() {
            return this.getMoldHeatHandler().map(h -> Float.valueOf(h.getTemperature())).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        public void setTemperature(float temp) {
            this.getMoldHeatHandler().ifPresent(h -> h.setTemperature(temp));
        }

        public int getTanks() {
            return this.getMoldFluidHandler().map(h -> h.getTanks()).orElse(0);
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getMoldFluidHandler().map(h -> h.getFluidInTank(tank)).orElse(FluidStack.EMPTY.copy());
        }

        public int getTankCapacity(int tank) {
            return this.getMoldFluidHandler().map(h -> h.getTankCapacity(tank)).orElse(0);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.getMoldFluidHandler().map(h -> h.isFluidValid(tank, stack)).orElse(false);
        }

        public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
            RecipeManager recipeManager;
            Optional<Pair> recipeResult;
            boolean usedMoldStack;
            ItemStack stack;
            if (!this.moldTable.getOutputStack().isEmpty()) {
                stack = this.moldTable.getOutputStack();
                usedMoldStack = false;
            } else {
                stack = this.moldTable.getMoldStack();
                usedMoldStack = true;
            }
            Level level = this.moldTable.getLevel();
            if (!stack.isEmpty() && level != null && (recipeResult = (recipeManager = level.getRecipeManager()).getAllRecipesFor((RecipeType)TFCRecipeTypes.BARREL_INSTANT.get()).stream().filter(recipeHolder -> ((InstantBarrelRecipe)recipeHolder.value()).getInputItem().test(stack) && ((InstantBarrelRecipe)recipeHolder.value()).getInputFluid().test(fluid)).findFirst().map(recipeHolder -> {
                InstantBarrelRecipe recipe = (InstantBarrelRecipe)recipeHolder.value();
                SizedIngredient inputItem = recipe.getInputItem();
                SizedFluidIngredient inputFluid = recipe.getInputFluid();
                int multiplier = inputItem.count() == 0 ? fluid.getAmount() / inputFluid.amount() : (inputFluid.amount() == 0 ? stack.getCount() / inputItem.count() : Math.min(fluid.getAmount() / inputFluid.amount(), stack.getCount() / inputItem.count()));
                ItemStack outputItem = recipe.getOutputItem().getSingleStack(stack);
                if (!outputItem.isEmpty()) {
                    outputItem.setCount(Math.min(outputItem.getMaxStackSize(), multiplier * outputItem.getCount()));
                }
                return Pair.of((Object)outputItem, (Object)(multiplier * inputFluid.amount()));
            })).isPresent()) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    if (usedMoldStack) {
                        this.moldTable.setMoldStack((ItemStack)recipeResult.get().getLeft());
                    } else {
                        this.moldTable.setOutputStack((ItemStack)recipeResult.get().getLeft());
                    }
                }
                return (Integer)recipeResult.get().getRight();
            }
            return this.getMoldFluidHandler().map(h -> h.fill(fluid, action)).orElse(0);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.getMoldFluidHandler().map(h -> h.drain(resource, action)).orElse(FluidStack.EMPTY.copy());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.getMoldFluidHandler().map(h -> h.drain(maxDrain, action)).orElse(FluidStack.EMPTY.copy());
        }
    }
}

