/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.container.NestBoxContainer;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.misc.Seat;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class NestBoxBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 4;

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestBoxBlockEntity nest) {
        nest.checkForLastTickSync();
        if (level.getGameTime() % 30L == 0L) {
            Entity sitter = Seat.getSittingEntity(level, pos);
            if (sitter instanceof OviparousAnimal) {
                OviparousAnimal bird = (OviparousAnimal)sitter;
                if (bird.isReadyForAnimalProduct()) {
                    if (bird.getRandom().nextInt(7) == 0) {
                        Helpers.playSound(level, pos, SoundEvents.CHICKEN_EGG);
                        if (Helpers.insertOne(nest, bird.makeEgg())) {
                            bird.setFertilized(false);
                            bird.setProductsCooldown();
                            bird.stopRiding();
                            nest.markForSync();
                        }
                    }
                } else {
                    bird.stopRiding();
                }
            }
            for (int slot = 0; slot < ((ItemStackHandler)nest.inventory).getSlots(); ++slot) {
                ItemStack stack = ((ItemStackHandler)nest.inventory).getStackInSlot(slot);
                @Nullable EggComponent egg = (EggComponent)stack.get(TFCComponents.EGG);
                if (egg == null || !egg.canHatch()) continue;
                egg.hatch(level).ifPresent(entity -> {
                    entity.moveTo(pos, 0.0f, 0.0f);
                    level.addFreshEntity(entity);
                });
                ((ItemStackHandler)nest.inventory).setStackInSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    public NestBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.NEST_BOX.get(), pos, state, NestBoxBlockEntity.defaultInventory(4));
        if (TFCConfig.SERVER.nestBoxEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).extractAll(), Direction.DOWN);
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.has(TFCComponents.EGG);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory inv, Player player) {
        return NestBoxContainer.create(this, inv, windowID);
    }
}

