/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PitKilnBlockEntity
extends PlacedItemBlockEntity {
    public static final Vec3i[] DIAGONALS = new Vec3i[]{new Vec3i(1, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1)};
    public static final int STRAW_NEEDED = 8;
    public static final int WOOD_NEEDED = 8;
    private final NonNullList<ItemStack> logItems = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> strawItems = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[4];
    private long litTick;
    private boolean isLit;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PitKilnBlockEntity pitKiln) {
        if (pitKiln.isLit) {
            BlockPos above = pos.above();
            if (level.isEmptyBlock(above)) {
                level.setBlockAndUpdate(above, Blocks.FIRE.defaultBlockState());
            } else {
                BlockState stateAbove = level.getBlockState(above);
                if (stateAbove.getBlock() != Blocks.FIRE) {
                    pitKiln.emptyFuelContents();
                    PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos, true);
                    return;
                }
            }
            if (!PitKilnBlockEntity.isValid(level, pos)) {
                pitKiln.emptyFuelContents();
                PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos, true);
                return;
            }
            long remainingTicks = (long)TFCConfig.SERVER.pitKilnTicks.get().intValue() - (Calendars.SERVER.getTicks() - pitKiln.litTick);
            if (remainingTicks <= 0L) {
                pitKiln.updateCache();
            }
            pitKiln.cookContents();
            if (remainingTicks <= 0L) {
                pitKiln.emptyFuelContents();
                level.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
                pitKiln.markForSync();
                PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos, true);
            }
        }
    }

    public static void convertPitKilnToPlacedItem(Level level, BlockPos pos, boolean playSound) {
        if (playSound) {
            Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
        }
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PIT_KILN.get()).ifPresent(pitKiln -> {
            List<ItemStack> items = Helpers.copyToAndClear(pitKiln.inventory);
            level.setBlock(pos, ((Block)TFCBlocks.PLACED_ITEM.get()).defaultBlockState(), 3);
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(placedItem -> {
                Helpers.copyFrom(items, placedItem.inventory);
                placedItem.isHoldingLargeItem = pitKiln.isHoldingLargeItem;
            });
        });
    }

    public static boolean isValid(Level level, BlockPos worldPosition) {
        for (Direction face : Direction.Plane.HORIZONTAL) {
            Direction opposite;
            BlockPos relativePos = worldPosition.relative(face);
            BlockState relativeState = level.getBlockState(relativePos);
            if (relativeState.isFaceSturdy((BlockGetter)level, relativePos, opposite = face.getOpposite()) && !relativeState.isFlammable((BlockGetter)level, relativePos, opposite)) continue;
            return false;
        }
        return level.getBlockState(worldPosition.below()).isFaceSturdy((BlockGetter)level, worldPosition.below(), Direction.UP);
    }

    public PitKilnBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PIT_KILN.get(), pos, state);
    }

    protected PitKilnBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.isLit = nbt.getBoolean("isLit");
        this.litTick = nbt.getLong("litTick");
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("strawItems"), this.strawItems, (HolderLookup.Provider)provider);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("logItems"), this.logItems, (HolderLookup.Provider)provider);
        this.updateCache();
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putBoolean("isLit", this.isLit);
        nbt.putLong("litTick", this.litTick);
        nbt.put("strawItems", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.strawItems, (HolderLookup.Provider)provider));
        nbt.put("logItems", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.logItems, (HolderLookup.Provider)provider));
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void ejectInventory() {
        assert (this.level != null);
        super.ejectInventory();
        if (!this.isLit) {
            this.strawItems.forEach(stack -> Helpers.spawnItem(this.level, this.worldPosition, stack));
            this.logItems.forEach(stack -> Helpers.spawnItem(this.level, this.worldPosition, stack));
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, BlockHitResult hit) {
        if (state.hasProperty((Property)PitKilnBlock.STAGE) && (Integer)state.getValue((Property)PitKilnBlock.STAGE) > 0) {
            for (ItemStack item : this.logItems.reversed()) {
                if (item.isEmpty()) continue;
                return item.copy();
            }
            for (ItemStack item : this.strawItems.reversed()) {
                if (item.isEmpty()) continue;
                return item.copy();
            }
        }
        return super.getCloneItemStack(state, hit);
    }

    public void deleteStraw(int slot) {
        this.strawItems.set(slot, (Object)ItemStack.EMPTY);
    }

    public void deleteLog(int slot) {
        this.logItems.set(slot, (Object)ItemStack.EMPTY);
    }

    public boolean isLit() {
        return this.isLit;
    }

    public long getLitTick() {
        return this.litTick;
    }

    public boolean hasFuel() {
        return (Integer)this.getBlockState().getValue((Property)PitKilnBlock.STAGE) == 15;
    }

    public boolean tryLight() {
        BlockPos above;
        this.updateCache();
        if (this.hasFuel() && this.level != null && PitKilnBlockEntity.isValid(this.level, this.worldPosition) && !this.isLit() && BaseFireBlock.canBePlacedAt((Level)this.level, (BlockPos)(above = this.worldPosition.above()), (Direction)Direction.UP)) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                if (this.level.getBlockState(this.worldPosition.relative(facing)).isFaceSturdy((BlockGetter)this.level, this.worldPosition.relative(facing), facing.getOpposite())) continue;
                return false;
            }
            this.light();
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PitKilnBlock.STAGE, (Comparable)Integer.valueOf(16)));
            this.level.setBlockAndUpdate(above, Blocks.FIRE.defaultBlockState());
            for (Vec3i diagonal : DIAGONALS) {
                BlockPos pitPos = this.worldPosition.offset(diagonal);
                BlockEntity blockEntity = this.level.getBlockEntity(pitPos);
                if (!(blockEntity instanceof PitKilnBlockEntity)) continue;
                PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
                kiln.tryLight();
            }
            return true;
        }
        return false;
    }

    private void light() {
        this.isLit = true;
        this.litTick = Calendars.SERVER.getTicks();
        this.markForSync();
    }

    public void emptyFuelContents() {
        this.strawItems.clear();
        this.logItems.clear();
    }

    public void addStraw(ItemStack stack, int slot) {
        this.strawItems.set(slot, (Object)stack);
    }

    public void addLog(ItemStack stack, int slot) {
        this.logItems.set(slot, (Object)stack);
    }

    public NonNullList<ItemStack> getLogs() {
        return this.logItems;
    }

    public NonNullList<ItemStack> getStraws() {
        return this.strawItems;
    }

    @VisibleForTesting
    public void cookContents() {
        assert (this.level != null);
        float progress = Mth.inverseLerp((float)Calendars.get((LevelReader)this.level).getTicks(), (float)this.litTick, (float)(this.litTick + (long)TFCConfig.SERVER.pitKilnTicks.get().intValue()));
        float eagerProgress = Mth.clamp((float)(progress * 1.125f), (float)0.0f, (float)1.0f);
        float targetTemperature = Mth.lerp((float)eagerProgress, (float)0.0f, (float)TFCConfig.SERVER.pitKilnTemperature.get().intValue());
        for (int slot = 0; slot < ((ItemStackHandler)this.inventory).getSlots(); ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat == null) continue;
            heat.setTemperature(targetTemperature);
            HeatingRecipe recipe = this.cachedRecipes[slot];
            if (recipe == null || !recipe.isValidTemperature(targetTemperature)) continue;
            ItemStack out = recipe.assembleItem(stack);
            ((ItemStackHandler)this.inventory).setStackInSlot(slot, out);
        }
    }

    public long getTicksLeft() {
        assert (this.level != null);
        return this.litTick + (long)TFCConfig.SERVER.pitKilnTicks.get().intValue() - Calendars.get((LevelReader)this.level).getTicks();
    }

    @VisibleForTesting
    public void updateCache() {
        for (int i = 0; i < 4; ++i) {
            this.cachedRecipes[i] = HeatingRecipe.getRecipe(((ItemStackHandler)this.inventory).getStackInSlot(i));
        }
    }
}

