/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.NonEmptyInput;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotBlockEntity
extends AbstractFirepitBlockEntity<PotInventory> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 8;
    public static final int PRE_BOIL_TIME = 100;
    private final SidedHandler<IFluidHandler> sidedFluidInventory = new SidedHandler<IFluidHandler>((IFluidHandler)this.inventory);
    @Nullable
    private PotOutput output = null;
    @Nullable
    private PotRecipe cachedRecipe = null;
    private int boilingTicks = 0;
    private int preBoilingTicks = 0;

    public PotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.POT.get(), pos, state, PotInventory::new);
        this.syncableData.add(() -> this.boilingTicks, value -> {
            this.boilingTicks = value;
        });
        if (TFCConfig.SERVER.firePitEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(4, 5, 6, 7, 8), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4, 5, 6, 7, 8), Direction.UP);
            this.sidedFluidInventory.on((IFluidHandler)((Function<IFluidHandler, IFluidHandler>)PartialFluidHandler::insertOnly), Direction.UP).on(PartialFluidHandler::extractOnly, (Predicate<Direction>)Direction.Plane.HORIZONTAL);
        }
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("output")) {
            this.output = PotOutput.read(provider, nbt.getCompound("output"));
        }
        this.boilingTicks = nbt.getInt("boilingTicks");
        this.preBoilingTicks = nbt.getInt("preBoilingTicks");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.output != null) {
            nbt.put("output", (Tag)PotOutput.write(provider, this.output));
        }
        nbt.putInt("boilingTicks", this.boilingTicks);
        nbt.putInt("preBoilingTicks", this.preBoilingTicks);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return slot >= 4 && slot <= 8 || super.isItemValid(slot, stack);
    }

    @Override
    protected void handleCooking() {
        if (this.isBoiling()) {
            if (this.preBoilingTicks < 100) {
                ++this.preBoilingTicks;
                return;
            }
            assert (this.cachedRecipe != null);
            if (this.boilingTicks < this.cachedRecipe.getDuration()) {
                ++this.boilingTicks;
                if (this.boilingTicks == 1) {
                    this.updateCachedRecipe();
                    this.markForSync();
                }
            } else {
                RecipeHelpers.setCraftingInput((IItemHandler)this.inventory, 4, 9);
                PotRecipe recipe = this.cachedRecipe;
                PotOutput output = recipe.getOutput((PotInventory)this.inventory);
                RecipeHelpers.clearCraftingInput();
                for (int slot = 4; slot <= 8; ++slot) {
                    ((PotInventory)this.inventory).setStackInSlot(slot, ((PotInventory)this.inventory).getStackInSlot(slot).getCraftingRemainingItem());
                }
                output.onFinish((PotInventory)this.inventory);
                if (!output.isEmpty()) {
                    this.output = output;
                }
                this.cachedRecipe = null;
                this.boilingTicks = 0;
                this.preBoilingTicks = 0;
                this.updateCachedRecipe();
                this.markForSync();
            }
        } else if (this.boilingTicks > 0) {
            this.boilingTicks = 0;
            this.preBoilingTicks = 0;
            this.markForSync();
        }
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        if (((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)FirepitBlock.LIT)).booleanValue()) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 3);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                if (this.isBoiling()) {
                    assert (this.cachedRecipe != null);
                    long ticksUsedWhileBurning = ticks - remainder.ticks();
                    if (ticksUsedWhileBurning > (long)(this.cachedRecipe.getDuration() - this.boilingTicks)) {
                        this.boilingTicks = this.cachedRecipe.getDuration();
                        this.handleCooking();
                    }
                }
                this.extinguish(this.level.getBlockState(this.worldPosition));
                this.coolInstantly();
            } else if (this.isBoiling()) {
                this.boilingTicks = (int)((long)this.boilingTicks + ticks);
            }
        }
    }

    @Override
    protected void coolInstantly() {
        this.boilingTicks = 0;
        this.preBoilingTicks = 0;
        this.markForSync();
    }

    @Override
    protected void updateCachedRecipe() {
        assert (this.level != null);
        this.cachedRecipe = this.level.getRecipeManager().getRecipeFor((RecipeType)TFCRecipeTypes.POT.get(), (RecipeInput)((PotInventory)this.inventory), this.level).map(RecipeHolder::value).orElse(null);
    }

    public boolean isBoiling() {
        return this.cachedRecipe != null && this.output == null && this.cachedRecipe.isHotEnough(this.temperature);
    }

    public boolean hasRecipeStarted() {
        return this.isBoiling() && this.preBoilingTicks >= 100;
    }

    public boolean shouldRenderAsBoiling() {
        return this.boilingTicks > 0;
    }

    public int getBoilingTicks() {
        return this.boilingTicks;
    }

    public ItemInteractionResult interactWithOutput(Player player, ItemStack stack) {
        if (this.output != null) {
            ItemInteractionResult result = this.output.onInteract(this, player, stack);
            if (this.output.isEmpty()) {
                this.output = null;
            }
            this.markForSync();
            return result;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public PotOutput getOutput() {
        return this.output;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return PotContainer.create(this, playerInv, windowID);
    }

    public static class PotInventory
    implements NonEmptyInput,
    DelegateItemHandler,
    DelegateFluidHandler,
    INBTSerializable<CompoundTag> {
        private final PotBlockEntity pot;
        private final ItemStackHandler inventory;
        private final FluidTank tank;

        public PotInventory(InventoryBlockEntity<PotInventory> entity) {
            this.pot = (PotBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 9);
            this.tank = new FluidTank(1000, fluid -> Helpers.isFluid(fluid.getFluid(), TFCTags.Fluids.USABLE_IN_POT));
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.pot.hasRecipeStarted() && slot >= 4 ? ItemStack.EMPTY : this.inventory.extractItem(slot, amount, simulate);
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("inventory", (Tag)this.inventory.serializeNBT(provider));
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        }

        public void clearFluid() {
            this.tank.setFluid(FluidStack.EMPTY);
        }
    }
}

