/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ScrapingBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    @Nullable
    private ResourceLocation inputTexture = null;
    @Nullable
    private ResourceLocation outputTexture = null;
    private short positions = 0;
    @Nullable
    private DyeColor color1 = null;
    @Nullable
    private DyeColor color2 = null;

    public ScrapingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SCRAPING.get(), pos, state, ScrapingBlockEntity.defaultInventory(1));
    }

    public boolean isComplete() {
        return this.positions == -1;
    }

    public short getScrapedPositions() {
        return this.positions;
    }

    public void onClicked(float hitX, float hitZ) {
        int xPos = (int)(hitX * 4.0f);
        int zPos = (int)(hitZ * 4.0f);
        this.positions = (short)(this.positions | 1 << xPos + zPos * 4);
        assert (this.level != null);
        if (!this.level.isClientSide) {
            ItemStack currentItem;
            ScrapingRecipe recipe;
            if (this.isComplete() && (recipe = ScrapingRecipe.getRecipe(currentItem = ((ItemStackHandler)this.inventory).getStackInSlot(0))) != null) {
                ItemStack extraDrop = recipe.getExtraDrop().getSingleStack(currentItem);
                if (!extraDrop.isEmpty()) {
                    Helpers.spawnItem(this.level, this.worldPosition, extraDrop);
                }
                ((ItemStackHandler)this.inventory).setStackInSlot(0, recipe.assemble(currentItem));
            }
            this.markForSync();
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public boolean dye(DyeColor color) {
        if (this.color1 == null) {
            this.color1 = color;
            this.markForSync();
            return true;
        }
        if (this.color2 == null) {
            this.color2 = color;
            this.markForSync();
            return true;
        }
        return false;
    }

    public int getColor1() {
        return this.color1 != null ? this.color1.getTextureDiffuseColor() : -1;
    }

    public int getColor2() {
        return this.color2 != null ? this.color2.getTextureDiffuseColor() : -1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return ScrapingRecipe.getRecipe(stack) != null;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.positions = nbt.getShort("positions");
        this.inputTexture = nbt.contains("inputTexture", 8) ? Helpers.resourceLocation(nbt.getString("inputTexture")) : null;
        this.outputTexture = nbt.contains("outputTexture", 8) ? Helpers.resourceLocation(nbt.getString("outputTexture")) : null;
        this.color1 = nbt.contains("color1", 3) ? DyeColor.byId((int)nbt.getInt("color1")) : null;
        this.color2 = nbt.contains("color2", 3) ? DyeColor.byId((int)nbt.getInt("color2")) : null;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putShort("positions", this.positions);
        if (this.inputTexture != null) {
            nbt.putString("inputTexture", this.inputTexture.toString());
        }
        if (this.outputTexture != null) {
            nbt.putString("outputTexture", this.outputTexture.toString());
        }
        if (this.color1 != null) {
            nbt.putInt("color1", this.color1.getId());
        }
        if (this.color2 != null) {
            nbt.putInt("color2", this.color2.getId());
        }
        super.saveAdditional(nbt, provider);
    }

    @Nullable
    public ResourceLocation getInputTexture() {
        return this.inputTexture;
    }

    @Nullable
    public ResourceLocation getOutputTexture() {
        return this.outputTexture;
    }

    public void updateDisplayCache() {
        if (!this.isComplete()) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
            ScrapingRecipe recipe = ScrapingRecipe.getRecipe(stack);
            this.inputTexture = recipe == null ? null : recipe.getInputTexture();
            this.outputTexture = recipe == null ? null : recipe.getOutputTexture();
        }
    }
}

