/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Optional;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TickCounterBlockEntity
extends TFCBlockEntity {
    protected long lastUpdateTick = Integer.MIN_VALUE;

    public static void reset(Level level, BlockPos pos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
    }

    public static void addTicks(Level level, BlockPos pos, long ticks) {
        Optional entity = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get());
        if (entity.isPresent()) {
            ((TickCounterBlockEntity)((Object)entity.get())).increaseCounter(ticks);
        }
    }

    public TickCounterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TICK_COUNTER.get(), pos, state);
    }

    protected TickCounterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public long getTicksSinceUpdate() {
        assert (this.level != null);
        return Calendars.get((LevelReader)this.level).getTicks() - this.lastUpdateTick;
    }

    public void setLastUpdateTick(long tick) {
        this.lastUpdateTick = tick;
        this.setChanged();
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public void resetCounter() {
        this.lastUpdateTick = Calendars.SERVER.getTicks();
        this.setChanged();
    }

    public void reduceCounter(long amount) {
        this.lastUpdateTick += amount;
        this.setChanged();
    }

    public void increaseCounter(long amount) {
        this.lastUpdateTick -= amount;
        this.setChanged();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.lastUpdateTick = nbt.getLong("tick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("tick", this.lastUpdateTick);
        super.saveAdditional(nbt, provider);
    }
}

