/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TickCountingBranchBlockEntity
extends TickCounterBlockEntity {
    private BlockPos stemPos;

    public static void reset(Level level, BlockPos pos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_BRANCH.get()).ifPresent(TickCounterBlockEntity::resetCounter);
    }

    public static void addTicks(Level level, BlockPos pos, long ticks) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_BRANCH.get()).ifPresent(entity -> entity.increaseCounter(ticks));
    }

    public static void setStemPos(Level level, BlockPos pos, BlockPos stemPos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_BRANCH.get()).ifPresent(entity -> entity.setStemPos(stemPos));
    }

    public TickCountingBranchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TICK_COUNTING_BRANCH.get(), pos, state);
    }

    public TickCountingBranchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.stemPos = pos;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("stemPos", 11)) {
            int[] stemArray = nbt.getIntArray("stemPos");
            this.stemPos = new BlockPos(stemArray[0], stemArray[1], stemArray[2]);
        } else {
            this.stemPos = nbt.contains("stemPos", 4) ? BlockPos.of((long)nbt.getLong("stemPos")) : this.worldPosition;
        }
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("stemPos", this.stemPos.asLong());
        nbt.putIntArray("stemPos", new int[]{this.stemPos.getX(), this.stemPos.getY(), this.stemPos.getZ()});
        super.saveAdditional(nbt, provider);
    }

    public void setStemPos(BlockPos stemPos) {
        this.stemPos = stemPos;
        this.setChanged();
    }

    public BlockPos getStemPos() {
        return this.stemPos;
    }
}

