/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class VaneBlockEntity
extends TickableBlockEntity {
    public static final float MAX_SPEED = 0.025f;
    private float targetAngle;
    private float angle;
    private float speed;
    private boolean shouldRotate = false;
    private boolean needsUpdate = false;

    protected VaneBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public VaneBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.VANE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, VaneBlockEntity vane) {
        if (vane.needsUpdate) {
            vane.markForSync();
            vane.needsUpdate = false;
        }
        if (level.getGameTime() % 40L == 0L) {
            float angle;
            Vec2 wind = Climate.get(level).getWind(level, pos);
            vane.angle = angle = (float)Mth.atan2((double)wind.y, (double)wind.x);
            if (vane.targetAngle != angle) {
                vane.targetAngle = angle;
                level.updateNeighborsAt(pos, state.getBlock());
                level.updateNeighborsAt(pos.below(), state.getBlock());
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, VaneBlockEntity vane) {
        float targetAngle;
        float currentAngle;
        if (level.getGameTime() % 40L == 0L) {
            Vec2 wind = Climate.get(level).getWind(level, pos);
            vane.targetAngle = (float)Mth.atan2((double)wind.y, (double)wind.x);
            vane.speed = Mth.clampedMap((float)wind.length(), (float)0.0f, (float)0.5f, (float)0.0f, (float)0.025f);
        }
        boolean bl = vane.shouldRotate = Math.abs((currentAngle = vane.angle) - (targetAngle = vane.targetAngle)) > vane.speed;
        if (vane.shouldRotate) {
            vane.angle = targetAngle > currentAngle ? Math.min(targetAngle, currentAngle + vane.speed) : Math.max(targetAngle, currentAngle - vane.speed);
        } else {
            float rand = level.random.nextFloat() - 0.5f;
            if ((double)Math.abs(rand) < 0.3) {
                rand = rand < 0.0f ? -0.3f : 0.3f;
            }
            vane.targetAngle += rand * ((float)Math.PI * 2) / 72.0f;
            vane.shouldRotate = true;
        }
    }

    public float getAngle(float partialTick) {
        if (this.shouldRotate) {
            return this.targetAngle > this.angle ? Math.min(this.targetAngle, this.angle + this.speed * partialTick) : Math.max(this.targetAngle, this.angle - this.speed * partialTick);
        }
        return this.angle;
    }

    public float getWrappedPositiveAngle() {
        return WeatherHelpers.wrappedPositiveAngle(this.targetAngle);
    }

    public int getRedstoneSignal() {
        return Math.clamp((long)Mth.floor((float)(this.getWrappedPositiveAngle() / ((float)Math.PI * 2) * 16.0f)), 0, 15);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("targetAngle", this.targetAngle);
        tag.putFloat("angle", this.angle);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.targetAngle = tag.getFloat("targetAngle");
        this.angle = tag.getFloat("angle");
        this.needsUpdate = true;
    }
}

