/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.FluidPumpBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends TFCBlockEntity {
    private static final int MAX_COST = 16;
    private static final int MAX_FILL = 32;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PumpBlockEntity pump) {
        if (level.getGameTime() % 40L == 0L) {
            Fluid fluid;
            Direction face = (Direction)state.getValue(FluidPumpBlock.FACING);
            BlockPos outputPos = pos.relative(face);
            BlockState outputState = level.getBlockState(outputPos);
            @Nullable CrankshaftBlockEntity shaft = CrankshaftBlockEntity.getCrankShaftAt((LevelAccessor)level, pos, face.getOpposite());
            Fluid fluid2 = fluid = PumpBlockEntity.isRotating(shaft) ? PumpBlockEntity.searchForFluid(level, pos) : null;
            if (fluid != null) {
                BlockState newState = FluidHelpers.fillWithFluid(outputState, fluid);
                if (newState != null && newState != outputState) {
                    level.setBlockAndUpdate(outputPos, newState);
                    level.scheduleTick(outputPos, fluid, fluid.getTickDelay((LevelReader)level));
                }
                if (newState == outputState) {
                    PumpBlockEntity.floodFill(level, pos, outputPos, fluid);
                }
            } else {
                PumpBlockEntity.removePlacedFluid(level, outputPos, outputState);
            }
        }
    }

    private static boolean isRotating(@Nullable CrankshaftBlockEntity shaft) {
        if (shaft != null) {
            Rotation rotation = shaft.getRotationNode().rotation();
            return rotation != null && rotation.speed() != 0.0f;
        }
        return false;
    }

    @Nullable
    private static Fluid searchForFluid(Level level, BlockPos start) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        ObjectOpenHashSet seen = new ObjectOpenHashSet(64);
        BlockPos below = start.below();
        BlockState stateBelow = level.getBlockState(below);
        if (!PumpBlockEntity.isPipe(stateBelow)) {
            return null;
        }
        PumpBlockEntity.enqueueConnections(cursor, level, new Path(stateBelow, below, 1), (Set<BlockPos>)seen, queue);
        while (!queue.isEmpty()) {
            Path prev = (Path)queue.poll();
            Fluid fluid = PumpBlockEntity.enqueueConnections(cursor, level, prev, (Set<BlockPos>)seen, queue);
            if (fluid == null) continue;
            return fluid;
        }
        return null;
    }

    @Nullable
    private static Fluid enqueueConnections(BlockPos.MutableBlockPos cursor, Level level, Path prev, Set<BlockPos> seen, Queue<Path> queue) {
        for (Direction direction : Helpers.DIRECTIONS) {
            cursor.setWithOffset((Vec3i)prev.pos, direction);
            if (seen.contains(cursor)) continue;
            BlockState stateAdj = level.getBlockState((BlockPos)cursor);
            if (PumpBlockEntity.isPipe(stateAdj)) {
                if (prev.cost >= 16) continue;
                BlockPos posAdj = cursor.immutable();
                queue.add(new Path(stateAdj, posAdj, 1 + prev.cost));
                seen.add(posAdj);
                continue;
            }
            if (!((Boolean)prev.state.getValue((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue() || prev.state.getFluidState().isEmpty() || prev.state.getFluidState().getType() != stateAdj.getFluidState().getType() || !FluidHelpers.isAirOrEmptyFluid(stateAdj)) continue;
            return stateAdj.getFluidState().getType();
        }
        return null;
    }

    private static void floodFill(Level level, BlockPos sourcePos, BlockPos pos, Fluid fluid) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        ObjectOpenHashSet seen = new ObjectOpenHashSet(64);
        BlockPos nextPos = null;
        int total = 0;
        queue.add(pos);
        seen.add(pos);
        seen.add(sourcePos);
        while (!queue.isEmpty()) {
            BlockPos prev = (BlockPos)queue.poll();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.setWithOffset((Vec3i)prev, direction);
                if (seen.contains(cursor)) continue;
                BlockPos current = cursor.immutable();
                seen.add(current);
                BlockState stateAt = level.getBlockState((BlockPos)cursor);
                if (stateAt.isAir() || PumpBlockEntity.isSourceOrFlowingFluidOf(stateAt, fluid)) {
                    cursor.move(0, -1, 0);
                    BlockState stateBelow = level.getBlockState((BlockPos)cursor);
                    if (stateBelow.getFluidState().isSourceOfType(fluid) || stateBelow.isFaceSturdy((BlockGetter)level, (BlockPos)cursor, Direction.UP)) {
                        if (nextPos == null && (stateAt.isAir() || !stateAt.getFluidState().isSource())) {
                            nextPos = current;
                        }
                        if (++total >= 32) {
                            return;
                        }
                        queue.add(current);
                        continue;
                    }
                    return;
                }
                if (stateAt.isFaceSturdy((BlockGetter)level, (BlockPos)cursor, direction.getOpposite())) continue;
                return;
            }
        }
        if (nextPos != null) {
            level.setBlockAndUpdate(nextPos, fluid.defaultFluidState().createLegacyBlock());
            level.scheduleTick(nextPos, fluid, fluid.getTickDelay((LevelReader)level));
        }
    }

    private static void removePlacedFluid(Level level, BlockPos outputPos, BlockState outputState) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.setWithOffset((Vec3i)outputPos, direction);
            if (!level.getFluidState((BlockPos)cursor).isSourceOfType(outputState.getFluidState().getType())) continue;
            return;
        }
        level.setBlockAndUpdate(outputPos, FluidHelpers.emptyFluidFrom(outputState));
    }

    private static boolean isSourceOrFlowingFluidOf(BlockState state, Fluid fluid) {
        boolean bl;
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            bl = flowing.isSame(state.getFluidState().getType());
        } else {
            bl = fluid == state.getFluidState().getType();
        }
        return bl;
    }

    private static boolean isPipe(BlockState state) {
        return state.getBlock() == TFCBlocks.STEEL_PIPE.get();
    }

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PUMP.get(), pos, state);
    }

    protected PumpBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onRemoved() {
        assert (this.level != null);
        Direction face = (Direction)this.getBlockState().getValue(FluidPumpBlock.FACING);
        BlockPos outputPos = this.worldPosition.relative(face);
        BlockState outputState = this.level.getBlockState(outputPos);
        PumpBlockEntity.removePlacedFluid(this.level, outputPos, outputState);
    }

    private record Path(BlockState state, BlockPos pos, int cost) {
    }
}

