/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.RotationNetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface RotatingBlockEntity {
    public static final int DELAY_FOR_INVALID_IN_NETWORK = 4;

    default public void performNetworkAction(NetworkAction action) {
        if (this.isInvalidInNetwork()) {
            return;
        }
        BlockEntity entity = this.self();
        Level level = entity.getLevel();
        if (!1.$assertionsDisabled && level == null) {
            throw new AssertionError();
        }
        RotationNetworkManager manager = RotationNetworkManager.get(level);
        if (!manager.performAction(this.getRotationNode(), action)) {
            this.markAsInvalidInNetwork();
            level.scheduleTick(entity.getBlockPos(), entity.getBlockState().getBlock(), 4);
        }
    }

    public void markAsInvalidInNetwork();

    public boolean isInvalidInNetwork();

    default public void destroyIfInvalid(Level level, BlockPos pos) {
        if (this.isInvalidInNetwork()) {
            level.destroyBlock(pos, true);
        }
    }

    public Node getRotationNode();

    default public float getRotationAngle(float partialTick) {
        return Rotation.angle(this.getRotationNode().rotation(), partialTick);
    }

    private BlockEntity self() {
        return (BlockEntity)this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

