/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.BladedAxleBlockEntity;
import net.dries007.tfc.common.blocks.TripHammerBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TripHammerBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    private int cooldownTicks = 10;

    public static void serverTick(Level level, BlockPos pos, BlockState state, TripHammerBlockEntity hammer) {
        float angle;
        if (hammer.cooldownTicks-- > 0) {
            return;
        }
        ItemStack item = ((ItemStackHandler)hammer.inventory).getStackInSlot(0);
        if (item.isEmpty()) {
            return;
        }
        Rotation rotation = hammer.getRotation();
        if (rotation != null && (angle = hammer.getRealRotationDegrees(rotation, 1.0f)) > 180.0f && angle < 183.0f) {
            if (rotation.positiveDirection() != ((Direction)state.getValue((Property)TripHammerBlock.FACING)).getClockWise()) {
                level.destroyBlock(pos, true);
                return;
            }
            BlockPos anvilPos = pos.relative((Direction)state.getValue((Property)TripHammerBlock.FACING));
            BlockEntity blockEntity = level.getBlockEntity(anvilPos);
            if (blockEntity instanceof AnvilBlockEntity) {
                AnvilBlockEntity anvil = (AnvilBlockEntity)blockEntity;
                if (level.getBlockState(anvilPos).getBlock() instanceof AnvilBlock) {
                    level.playSound(null, pos, (SoundEvent)TFCSounds.ANVIL_HIT.get(), SoundSource.BLOCKS, 0.4f, 0.2f);
                    if (anvil.workRemotely(ForgeStep.HIT_LIGHT, 12, true)) {
                        Helpers.damageItem(item, level);
                        anvil.markForSync();
                    }
                    hammer.cooldownTicks = Mth.ceil((float)(5.0265484f / rotation.positiveSpeed()));
                }
            }
        }
    }

    public TripHammerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TRIP_HAMMER.get(), pos, state);
    }

    public TripHammerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, TripHammerBlockEntity.defaultInventory(1));
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.TRIP_HAMMERS);
    }

    public float getRealRotationDegrees(Rotation rotation, float partialTick) {
        return 57.295776f * rotation.angle(partialTick);
    }

    @Nullable
    public Rotation getRotation() {
        assert (this.level != null);
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.above());
        if (blockEntity instanceof BladedAxleBlockEntity) {
            BladedAxleBlockEntity axle = (BladedAxleBlockEntity)blockEntity;
            return axle.getRotationNode().rotation();
        }
        return null;
    }
}

