/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SourceNode;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WaterWheelBlockEntity
extends TickableBlockEntity
implements RotatingBlockEntity {
    public static final float MAX_SPEED = 0.07853982f;
    public static final float LERP_SPEED = 1.9634955E-4f;
    private static final float MAX_FLOW = 10.0f;
    private final SourceNode node;
    private boolean invalid;
    private float targetSpeed;
    private boolean obstructed;

    public static void serverTick(Level level, BlockPos pos, BlockState state, WaterWheelBlockEntity wheel) {
        wheel.checkForLastTickSync();
        WaterWheelBlockEntity.clientTick(level, pos, state, wheel);
        if (level.getGameTime() % 40L == 0L) {
            Float maybeFlowRate = WaterWheelBlockEntity.calculateFlowRateAndObstruction(level, pos, (Direction.Axis)state.getValue(WaterWheelBlock.AXIS));
            if (maybeFlowRate == null) {
                wheel.obstructed = true;
                wheel.markForSync();
            } else {
                wheel.obstructed = false;
                wheel.targetSpeed = maybeFlowRate.floatValue() * 0.07853982f / 10.0f;
                wheel.markForSync();
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WaterWheelBlockEntity wheel) {
        Rotation.Tickable rotation = wheel.node.rotation();
        rotation.tick();
        if (wheel.obstructed) {
            rotation.setSpeed(0.0f);
        } else {
            float targetSpeed = wheel.targetSpeed;
            float currentSpeed = rotation.speed();
            float nextSpeed = targetSpeed > currentSpeed ? Math.min(targetSpeed, currentSpeed + 1.9634955E-4f) : Math.max(targetSpeed, currentSpeed - 1.9634955E-4f);
            rotation.setSpeed(nextSpeed);
        }
    }

    public boolean isObstructed() {
        return this.obstructed;
    }

    @Nullable
    public static Float calculateFlowRateAndObstruction(Level level, BlockPos pos, Direction.Axis axis) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        float contributingFlow = 0.0f;
        float obstructionFlow = 0.0f;
        for (int dH = -2; dH <= 2; ++dH) {
            for (int dy = -2; dy <= 2; ++dy) {
                if (dH == 0 && dy == 0) continue;
                cursor.setWithOffset((Vec3i)pos, axis == Direction.Axis.X ? 0 : dH, dy, axis == Direction.Axis.Z ? 0 : dH);
                BlockState state = level.getBlockState((BlockPos)cursor);
                if (state.getBlock() == TFCBlocks.RIVER_WATER.get()) {
                    Flow flow = (Flow)((Object)state.getValue(RiverWaterBlock.FLOW));
                    float flowRate = (float)(axis == Direction.Axis.X ? -flow.getVector().z : flow.getVector().x);
                    if (dy < 0) {
                        contributingFlow += flowRate;
                        continue;
                    }
                    obstructionFlow += Math.abs(flowRate);
                    continue;
                }
                if (state.getBlock() == Blocks.WATER) {
                    obstructionFlow += dy < 0 ? 0.25f : 1.0f;
                    continue;
                }
                if (state.isAir() || state.getCollisionShape((BlockGetter)level, (BlockPos)cursor).isEmpty()) continue;
                return null;
            }
        }
        if (contributingFlow > 0.0f) {
            return Float.valueOf(-Math.max(0.0f, contributingFlow - obstructionFlow));
        }
        return Float.valueOf(-Math.min(0.0f, contributingFlow + obstructionFlow));
    }

    public WaterWheelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), pos, state);
    }

    public WaterWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        final Direction.Axis axis = (Direction.Axis)state.getValue(WaterWheelBlock.AXIS);
        this.targetSpeed = 0.0f;
        this.invalid = false;
        this.node = new SourceNode(this, pos, Node.ofAxis(axis), Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0.0f){

            @Override
            public String toString() {
                return "WaterWheel[pos=%s, axis=%s]".formatted(this.pos(), axis);
            }
        };
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.node.rotation().saveToTag(tag);
        tag.putBoolean("invalid", this.invalid);
        tag.putFloat("targetSpeed", this.targetSpeed);
        tag.putBoolean("obstructed", this.obstructed);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.node.rotation().loadFromTag(tag);
        this.invalid = tag.getBoolean("invalid");
        this.targetSpeed = tag.getFloat("targetSpeed");
        this.obstructed = tag.getBoolean("obstructed");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }
}

