/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CharcoalPileBlock
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    public static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.empty(), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), CharcoalPileBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Shapes.block()};

    public CharcoalPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        int prevLayers = (Integer)state.getValue((Property)LAYERS);
        if (prevLayers > 1 && !player.isCreative()) {
            return level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(prevLayers - 1)), level.isClientSide() ? 11 : 3);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.CHARCOAL);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.LAND && (Integer)state.getValue((Property)LAYERS) < 5;
    }

    protected BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!level.isClientSide() && facing == Direction.DOWN && Helpers.isBlock(facingState, this)) {
            int layersAt = (Integer)stateIn.getValue((Property)LAYERS);
            int layersUnder = (Integer)facingState.getValue((Property)LAYERS);
            if (layersUnder < 8) {
                if (layersUnder + layersAt <= 8) {
                    level.setBlock(facingPos, (BlockState)facingState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layersAt + layersUnder)), 3);
                    level.destroyBlock(currentPos, false);
                    return Blocks.AIR.defaultBlockState();
                }
                level.setBlock(facingPos, (BlockState)facingState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(8)), 3);
                return (BlockState)stateIn.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layersAt + layersUnder - 8));
            }
        }
        return this.canSurvive(stateIn, (LevelReader)level, currentPos) ? stateIn : Blocks.AIR.defaultBlockState();
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS)];
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP) || blockstate.getBlock() == this && (Integer)blockstate.getValue((Property)LAYERS) == 8;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS)];
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS) - 1];
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{LAYERS}));
    }
}

