/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface DirectionPropertyBlock {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final ImmutableMap<BooleanProperty, Direction> TO_DIRECTION = ImmutableMap.builder().put((Object)BlockStateProperties.DOWN, (Object)Direction.DOWN).put((Object)BlockStateProperties.UP, (Object)Direction.UP).put((Object)BlockStateProperties.NORTH, (Object)Direction.NORTH).put((Object)BlockStateProperties.SOUTH, (Object)Direction.SOUTH).put((Object)BlockStateProperties.WEST, (Object)Direction.WEST).put((Object)BlockStateProperties.EAST, (Object)Direction.EAST).build();
    public static final BooleanProperty[] PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    @NotNull
    public static BooleanProperty getProperty(Direction direction) {
        return PROPERTIES[direction.ordinal()];
    }

    @NotNull
    public static Direction getDirection(BooleanProperty property) {
        return (Direction)TO_DIRECTION.get((Object)property);
    }

    public static BlockState setAllDirections(BlockState state, boolean value) {
        for (BooleanProperty property : PROPERTIES) {
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(value));
        }
        return state;
    }

    public static Map<BlockState, VoxelShape> makeShapeCache(StateDefinition<Block, BlockState> stateDefinition, Function<BooleanProperty, VoxelShape> toShape) {
        return stateDefinition.getPossibleStates().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), state -> Arrays.stream(PROPERTIES).filter(arg_0 -> ((BlockState)state).getValue(arg_0)).map(toShape).reduce(Shapes::or).orElseGet(Shapes::empty)));
    }

    public static BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            default -> state;
        };
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> state;
        };
    }
}

