/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ExtendedProperties {
    private final BlockBehaviour.Properties properties;
    @Nullable
    private BiFunction<BlockPos, BlockState, ? extends BlockEntity> blockEntityFactory;
    @Nullable
    private Supplier<? extends BlockEntityType<?>> blockEntityType;
    @Nullable
    private BlockEntityTicker<?> serverTicker;
    @Nullable
    private BlockEntityTicker<?> clientTicker;
    private int flammability;
    private int fireSpreadSpeed;
    @Nullable
    private PathType pathType;
    private ToDoubleFunction<BlockState> enchantmentPowerGetter;
    @Nullable
    private Supplier<ItemStack> cloneItemStack;

    public static ExtendedProperties of(BlockBehaviour.Properties properties) {
        return new ExtendedProperties(properties);
    }

    public static ExtendedProperties of(BlockBehaviour block) {
        return ExtendedProperties.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block));
    }

    public static ExtendedProperties of() {
        return ExtendedProperties.of(BlockBehaviour.Properties.of());
    }

    public static ExtendedProperties of(DyeColor color) {
        return ExtendedProperties.of(BlockBehaviour.Properties.of().mapColor(color));
    }

    public static ExtendedProperties of(MapColor materialColor) {
        return ExtendedProperties.of(BlockBehaviour.Properties.of().mapColor(materialColor));
    }

    public static ExtendedProperties of(Function<BlockState, MapColor> materialColor) {
        return ExtendedProperties.of(BlockBehaviour.Properties.of().mapColor(materialColor));
    }

    private ExtendedProperties(BlockBehaviour.Properties properties) {
        this.properties = properties;
        this.blockEntityFactory = null;
        this.blockEntityType = null;
        this.serverTicker = null;
        this.clientTicker = null;
        this.flammability = 0;
        this.fireSpreadSpeed = 0;
        this.pathType = null;
        this.enchantmentPowerGetter = s -> 0.0;
        this.cloneItemStack = null;
    }

    public ExtendedProperties blockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType) {
        this.blockEntityType = blockEntityType;
        this.blockEntityFactory = (pos, state) -> ((BlockEntityType)blockEntityType.get()).create(pos, state);
        return this;
    }

    public <T extends BlockEntity> ExtendedProperties ticks(BlockEntityTicker<T> ticker) {
        return this.ticks(ticker, ticker);
    }

    public <T extends BlockEntity> ExtendedProperties serverTicks(BlockEntityTicker<T> serverTicker) {
        return this.ticks(serverTicker, null);
    }

    public <T extends BlockEntity> ExtendedProperties clientTicks(BlockEntityTicker<T> clientTicker) {
        return this.ticks(null, clientTicker);
    }

    public <T extends BlockEntity> ExtendedProperties ticks(@Nullable BlockEntityTicker<T> serverTicker, @Nullable BlockEntityTicker<T> clientTicker) {
        assert (this.blockEntityType != null) : "Must call .blockEntity() before adding a ticker";
        assert (this.serverTicker == null && this.clientTicker == null) : "Calling ticks() twice, can only call one of ticks(), clientTicks(), or serverTicks()";
        this.serverTicker = serverTicker;
        this.clientTicker = clientTicker;
        return this;
    }

    public ExtendedProperties flammable(int flammability, int fireSpreadSpeed) {
        this.flammability = flammability;
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    public ExtendedProperties flammableLikeLogs() {
        return this.flammable(5, 5).ignitedByLava();
    }

    public ExtendedProperties flammableLikePlanks() {
        return this.flammable(20, 5).ignitedByLava();
    }

    public ExtendedProperties flammableLikeLeaves() {
        return this.flammable(60, 30).ignitedByLava();
    }

    public ExtendedProperties flammableLikeWool() {
        return this.flammable(100, 60).ignitedByLava();
    }

    public ExtendedProperties pathType(PathType type) {
        this.pathType = type;
        return this;
    }

    public ExtendedProperties enchantPower(float power) {
        this.enchantmentPowerGetter = s -> power;
        return this;
    }

    public ExtendedProperties enchantPower(ToDoubleFunction<BlockState> powerGetter) {
        this.enchantmentPowerGetter = powerGetter;
        return this;
    }

    public ExtendedProperties cloneEmpty() {
        this.cloneItemStack = () -> ItemStack.EMPTY;
        return this;
    }

    public ExtendedProperties cloneItem(@Nullable ItemLike cloneItemStack) {
        this.cloneItemStack = cloneItemStack == null ? null : () -> new ItemStack(cloneItemStack);
        return this;
    }

    public BlockBehaviour.Properties properties() {
        return this.properties;
    }

    @ApiStatus.Internal
    public boolean hasBlockEntity() {
        return this.blockEntityType != null;
    }

    public <T extends BlockEntity> BlockEntityType<T> blockEntity() {
        assert (this.blockEntityType != null);
        return this.blockEntityType.get();
    }

    public ExtendedProperties noCollission() {
        this.properties.noCollission();
        return this;
    }

    public ExtendedProperties noOcclusion() {
        this.properties.noOcclusion();
        return this;
    }

    public ExtendedProperties friction(float friction) {
        this.properties.friction(friction);
        return this;
    }

    public ExtendedProperties speedFactor(float speedFactor) {
        this.properties.speedFactor(speedFactor);
        return this;
    }

    public ExtendedProperties jumpFactor(float jumpFactor) {
        this.properties.jumpFactor(jumpFactor);
        return this;
    }

    public ExtendedProperties sound(SoundType sound) {
        this.properties.sound(sound);
        return this;
    }

    public ExtendedProperties lightLevel(ToIntFunction<BlockState> lightLevel) {
        this.properties.lightLevel(lightLevel);
        return this;
    }

    public ExtendedProperties strength(float destroyTime, float explosionResistance) {
        this.properties.strength(destroyTime, explosionResistance);
        return this;
    }

    public ExtendedProperties instabreak() {
        this.properties.instabreak();
        return this;
    }

    public ExtendedProperties strength(float strength) {
        this.properties.strength(strength);
        return this;
    }

    public ExtendedProperties randomTicks() {
        this.properties.randomTicks();
        return this;
    }

    public ExtendedProperties dynamicShape() {
        this.properties.dynamicShape();
        return this;
    }

    public ExtendedProperties noLootTable() {
        this.properties.noLootTable();
        return this;
    }

    public ExtendedProperties dropsLike(Block block) {
        this.properties.lootFrom(() -> block);
        return this;
    }

    public ExtendedProperties dropsLike(Supplier<Block> block) {
        this.properties.lootFrom(block);
        return this;
    }

    public ExtendedProperties air() {
        this.properties.air();
        return this;
    }

    public ExtendedProperties isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> isValidSpawn) {
        this.properties.isValidSpawn(isValidSpawn);
        return this;
    }

    public ExtendedProperties isRedstoneConductor(BlockBehaviour.StatePredicate isRedstoneConductor) {
        this.properties.isRedstoneConductor(isRedstoneConductor);
        return this;
    }

    public ExtendedProperties isSuffocating(BlockBehaviour.StatePredicate isSuffocating) {
        this.properties.isSuffocating(isSuffocating);
        return this;
    }

    public ExtendedProperties isViewBlocking(BlockBehaviour.StatePredicate isViewBlocking) {
        this.properties.isViewBlocking(isViewBlocking);
        return this;
    }

    public ExtendedProperties hasPostProcess(BlockBehaviour.StatePredicate hasPostProcess) {
        this.properties.hasPostProcess(hasPostProcess);
        return this;
    }

    public ExtendedProperties emissiveRendering(BlockBehaviour.StatePredicate emissiveRendering) {
        this.properties.emissiveRendering(emissiveRendering);
        return this;
    }

    public ExtendedProperties requiresCorrectToolForDrops() {
        this.properties.requiresCorrectToolForDrops();
        return this;
    }

    public ExtendedProperties mapColor(MapColor color) {
        this.properties.mapColor(color);
        return this;
    }

    public ExtendedProperties mapColor(Function<BlockState, MapColor> mapColor) {
        this.properties.mapColor(mapColor);
        return this;
    }

    public ExtendedProperties mapColor(DyeColor color) {
        this.properties.mapColor(color);
        return this;
    }

    public ExtendedProperties destroyTime(float destroyTime) {
        this.properties.destroyTime(destroyTime);
        return this;
    }

    public ExtendedProperties explosionResistance(float explosionResistance) {
        this.properties.explosionResistance(explosionResistance);
        return this;
    }

    public ExtendedProperties ignitedByLava() {
        this.properties.ignitedByLava();
        return this;
    }

    public ExtendedProperties liquid() {
        this.properties.liquid();
        return this;
    }

    public ExtendedProperties forceSolidOn() {
        this.properties.forceSolidOn();
        return this;
    }

    public ExtendedProperties forceSolidOff() {
        this.properties.forceSolidOff();
        return this;
    }

    public ExtendedProperties pushReaction(PushReaction reaction) {
        this.properties.pushReaction(reaction);
        return this;
    }

    public ExtendedProperties offsetType(BlockBehaviour.OffsetType type) {
        this.properties.offsetType(type);
        return this;
    }

    public ExtendedProperties requiredFeatures(FeatureFlag ... flags) {
        this.properties.requiredFeatures(flags);
        return this;
    }

    public ExtendedProperties instrument(NoteBlockInstrument inst) {
        this.properties.instrument(inst);
        return this;
    }

    public ExtendedProperties defaultInstrument() {
        return this.instrument(NoteBlockInstrument.HARP);
    }

    public ExtendedProperties replaceable() {
        this.properties.replaceable();
        return this;
    }

    @Nullable
    BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityFactory == null ? null : this.blockEntityFactory.apply(pos, state);
    }

    @Nullable
    <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockEntityType<T> givenType) {
        assert (this.blockEntityType != null);
        if (givenType == this.blockEntityType.get()) {
            return level.isClientSide() ? this.clientTicker : this.serverTicker;
        }
        return null;
    }

    int getFlammability() {
        return this.flammability;
    }

    int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    @Nullable
    PathType getPathType() {
        return this.pathType;
    }

    float getEnchantmentPower(BlockState state) {
        return (float)this.enchantmentPowerGetter.applyAsDouble(state);
    }

    ItemStack getCloneItemStack(Block block) {
        return this.cloneItemStack == null ? new ItemStack((ItemLike)block) : this.cloneItemStack.get();
    }
}

