/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroundcoverBlock
extends ExtendedBlock
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    public static final VoxelShape FLAT = GroundcoverBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    public static final VoxelShape SMALL = GroundcoverBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    public static final VoxelShape MEDIUM = GroundcoverBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    public static final VoxelShape PIXEL_HIGH = GroundcoverBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape TWIG = GroundcoverBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final VoxelShape shape;

    public static GroundcoverBlock twig(ExtendedProperties properties) {
        return new GroundcoverBlock(properties.flammable(60, 30), TWIG);
    }

    public static GroundcoverBlock looseOre(BlockBehaviour.Properties properties) {
        return new GroundcoverBlock(ExtendedProperties.of(properties), SMALL);
    }

    public GroundcoverBlock(GroundcoverBlockType cover) {
        this(ExtendedProperties.of(MapColor.PLANT).strength(0.05f, 0.0f).sound(SoundType.NETHER_WART).noCollission().pushReaction(PushReaction.DESTROY).cloneItem(cover.getVanillaItem()), cover.getShape());
    }

    public GroundcoverBlock(ExtendedProperties properties, VoxelShape shape) {
        super(properties);
        this.shape = shape;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY)));
    }

    @Override
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (fluid instanceof FlowingFluid && !this.getFluidProperty().canContain(fluid)) {
            return true;
        }
        return IFluidLoggable.super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    @Override
    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.getType() instanceof FlowingFluid && !this.getFluidProperty().canContain(fluidStateIn.getType())) {
            level.destroyBlock(pos, true);
            level.setBlock(pos, fluidStateIn.createLegacyBlock(), 2);
            return true;
        }
        return IFluidLoggable.super.placeLiquid(level, pos, state, fluidStateIn);
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = this.defaultBlockState();
        if (this.getFluidProperty().canContain(fluidState.getType())) {
            return (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getFluidProperty()});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state.canSurvive((LevelReader)level, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isCreative() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity entity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
            GroundcoverBlock.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)entity, null, (ItemStack)ItemStack.EMPTY).forEach(stackToSpawn -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackToSpawn));
        }
        level.removeBlock(pos, false);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return level.getBlockState(belowPos).isFaceSturdy((BlockGetter)level, belowPos, Direction.UP);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }
}

