/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.DataMapHooks;

public interface IWeatheringBlock {
    public Age getAge();

    default public float ageModifier() {
        return this.getAge() == Age.NONE ? 0.5f : 1.0f;
    }

    public float weatheringResistance();

    default public void onRandomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float randomChance;
        float resistanceThreshold = 1.0f - this.weatheringResistance();
        if (this.getAge() == Age.OXIDIZED || random.nextFloat() < 0.95f || random.nextFloat() > resistanceThreshold) {
            return;
        }
        float chance = random.nextFloat();
        if (chance < (randomChance = this.ageModifier() * 0.05f)) {
            this.changeToNextState(level, pos, state);
            return;
        }
        float count = 0.0f;
        float overall = 0.0f;
        for (BlockPos next : BlockPos.withinManhattan((BlockPos)pos, (int)4, (int)4, (int)4)) {
            Block block = level.getBlockState(next).getBlock();
            if (!(block instanceof IWeatheringBlock)) continue;
            IWeatheringBlock weatheringBlock = (IWeatheringBlock)block;
            if (weatheringBlock.getAge().ordinal() > this.getAge().ordinal()) {
                count += 1.0f;
            }
            overall += 1.0f;
        }
        float neighborModifier = 1.0f;
        if (count / overall > 0.4f) {
            neighborModifier = 2.5E-4f;
        }
        int adjacentCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            if (!(level.getBlockState(pos.relative(direction)).getBlock() instanceof IWeatheringBlock)) continue;
            ++adjacentCount;
        }
        if (adjacentCount <= 3) {
            IWeatheringBlock weatheringBlock;
            Block block;
            float drip = 0.0f;
            for (int y = 1; y < 5 && (block = level.getBlockState(pos.above(y)).getBlock()) instanceof IWeatheringBlock && (weatheringBlock = (IWeatheringBlock)block).getAge().ordinal() > this.getAge().ordinal(); ++y) {
                drip += 0.2f;
            }
            float overallChance = this.ageModifier() * drip;
            if (this.getAge() != Age.NONE) {
                overallChance *= neighborModifier;
            }
            if (chance < overallChance) {
                this.changeToNextState(level, pos, state);
                return;
            }
        }
        boolean topExposed = true;
        for (int y = 1; y < 5; ++y) {
            if (level.getBlockState(pos.above(y)).getCollisionShape((BlockGetter)level, pos.above(y)).isEmpty()) continue;
            topExposed = false;
            break;
        }
        if (topExposed) {
            float overallChance = this.ageModifier() * this.climateModifier((Level)level, pos);
            if (this.getAge() != Age.NONE) {
                overallChance *= neighborModifier;
            }
            if (chance < overallChance) {
                this.changeToNextState(level, pos, state);
                return;
            }
        }
    }

    private float climateModifier(Level level, BlockPos pos) {
        ClimateModel model = Climate.get(level);
        float temp = Mth.abs((float)(-0.5f + (Mth.clamp((float)model.getTemperature((LevelReader)level, pos), (float)-40.0f, (float)40.0f) + 40.0f) / 80.0f)) * 2.0f;
        float rainfall = Mth.clamp((float)model.getAverageRainfall((LevelReader)level, pos), (float)0.0f, (float)500.0f) / 500.0f;
        float wind = Mth.clamp((float)model.getWind(level, pos).length(), (float)0.0f, (float)1.0f);
        float raining = level.isRainingAt(pos) ? 1.0f : 0.5f;
        float climate = temp * rainfall;
        float weather = raining * wind;
        return (Mth.clamp((float)climate, (float)0.0f, (float)1.0f) + 0.2f) * 0.6f + (Mth.clamp((float)weather, (float)0.0f, (float)1.0f) + 0.2f) * 0.4f;
    }

    private void changeToNextState(ServerLevel level, BlockPos pos, BlockState state) {
        Block block = DataMapHooks.getNextOxidizedStage((Block)state.getBlock());
        if (block != null) {
            BlockState next = Helpers.copyProperties(block.defaultBlockState(), state);
            level.setBlockAndUpdate(pos, next);
        }
    }

    public static enum Age {
        NONE,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

