/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MoltenBlock
extends ExtendedBlock {
    public static final IntegerProperty LAYERS = TFCBlockStateProperties.LAYERS_4;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public static void removeMoltenBlockTower(Level level, BlockPos pos, int maxHeight) {
        MoltenBlock.manageMoltenBlockTower(level, pos, false, maxHeight, 0, 1);
    }

    public static void manageMoltenBlockTower(Level level, BlockPos pos, boolean lit, int maxHeight, int itemCount, int itemsPerLayer) {
        BlockState state = (BlockState)((Block)TFCBlocks.MOLTEN.get()).defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(lit));
        int layers = 0;
        if (itemCount > 0) {
            layers = Math.max(1, 4 * itemCount / itemsPerLayer);
        }
        for (int y = 0; y < maxHeight; ++y) {
            BlockPos checkPos = pos.above(y);
            if (layers >= 4) {
                level.setBlockAndUpdate(checkPos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(4)));
                layers -= 4;
                continue;
            }
            if (layers > 0) {
                level.setBlockAndUpdate(checkPos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers)));
                layers = 0;
                continue;
            }
            if (!Helpers.isBlock(level.getBlockState(checkPos), (Block)TFCBlocks.MOLTEN.get())) continue;
            level.setBlockAndUpdate(checkPos, Blocks.AIR.defaultBlockState());
        }
    }

    public MoltenBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, LIT});
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)level.getBlockState(pos).getValue((Property)LIT)).booleanValue()) {
            entity.hurt(entity.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && level.isEmptyBlock(pos.above())) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.1;
            double z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, (double)Helpers.triangle(random) * 0.1, 0.2, (double)Helpers.triangle(random) * 0.1);
            if (random.nextInt(10) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, (double)Helpers.triangle(random) * 0.1, 0.5, (double)Helpers.triangle(random) * 0.1);
            }
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (level.getBlockState(pos.above()).isAir() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            Helpers.fireSpreaderTick(level, pos, rand, 2);
        }
    }
}

