/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PouredGlassBlock
extends ExtendedBlock {
    public static final VoxelShape SHAPE = PouredGlassBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final Supplier<? extends Item> drop;

    public static Item getStainedGlass(DyeColor color) {
        return switch (color) {
            case DyeColor.WHITE -> Items.WHITE_STAINED_GLASS_PANE;
            case DyeColor.ORANGE -> Items.ORANGE_STAINED_GLASS_PANE;
            case DyeColor.MAGENTA -> Items.MAGENTA_STAINED_GLASS_PANE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_STAINED_GLASS_PANE;
            case DyeColor.YELLOW -> Items.YELLOW_STAINED_GLASS_PANE;
            case DyeColor.LIME -> Items.LIME_STAINED_GLASS_PANE;
            case DyeColor.PINK -> Items.PINK_STAINED_GLASS_PANE;
            case DyeColor.GRAY -> Items.GRAY_STAINED_GLASS_PANE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_STAINED_GLASS_PANE;
            case DyeColor.CYAN -> Items.CYAN_STAINED_GLASS_PANE;
            case DyeColor.PURPLE -> Items.PURPLE_STAINED_GLASS_PANE;
            case DyeColor.BLUE -> Items.BLUE_STAINED_GLASS_PANE;
            case DyeColor.BROWN -> Items.BROWN_STAINED_GLASS_PANE;
            case DyeColor.GREEN -> Items.GREEN_STAINED_GLASS_PANE;
            case DyeColor.RED -> Items.RED_STAINED_GLASS_PANE;
            default -> Items.BLACK_STAINED_GLASS_PANE;
        };
    }

    public PouredGlassBlock(ExtendedProperties properties, Supplier<? extends Item> drop) {
        super(properties);
        this.drop = drop;
    }

    public Item getDrop() {
        return this.drop.get();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return BottomSupportedDeviceBlock.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? super.getStateForPlacement(context) : null;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !facingState.isFaceSturdy((BlockGetter)level, facingPos, Direction.UP) && !Helpers.isBlock(facingState, TFCTags.Blocks.SOLID_TOP_FACE) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

