/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.BucketPickupExtension;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class RiverWaterBlock
extends LiquidBlock
implements BucketPickupExtension {
    public static final EnumProperty<Flow> FLOW = TFCBlockStateProperties.FLOW;

    public RiverWaterBlock(BlockBehaviour.Properties properties) {
        super((FlowingFluid)TFCFluids.RIVER_WATER.get(), properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue(FLOW, (Comparable)((Object)Flow.NONE)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (ClientHelpers.useFancyGraphics() && random.nextInt(34) == 0 && level.getBlockState(pos.above()).isAir()) {
            for (int i = 0; i < 3; ++i) {
                level.addParticle((ParticleOptions)TFCParticles.WATER_FLOW.get(), (double)((float)pos.getX() + random.nextFloat()), (double)pos.getY() + 0.875, (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public FluidStack pickupBlock(LevelAccessor level, BlockPos pos, BlockState state, IFluidHandler.FluidAction action) {
        if ((Integer)state.getValue((Property)LEVEL) == 0) {
            if (action.execute()) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            }
            return new FluidStack((Fluid)Fluids.WATER, 1000);
        }
        return FluidStack.EMPTY;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.pickupBlock(level, pos, state, IFluidHandler.FluidAction.EXECUTE).getFluid().getBucket());
    }

    public FluidState getFluidState(BlockState state) {
        return (FluidState)this.fluid.defaultFluidState().setValue(FLOW, (Comparable)((Object)((Flow)((Object)state.getValue(FLOW)))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FLOW}));
    }
}

