/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SeaIceBlock
extends IceBlock {
    public SeaIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (fallDistance > 5.0f) {
            this.melt(state, level, pos);
            level.addDestroyBlockEffect(pos, state);
            Helpers.playSound(level, pos, SoundEvents.GLASS_BREAK);
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 0, 1))) {
                if (!(level.getBlockState(testPos).getBlock() instanceof SeaIceBlock)) continue;
                this.melt(state, level, testPos);
                level.addDestroyBlockEffect(testPos, state);
            }
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, te, stack);
        if (EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_ICE_MELTING)) {
            if (level.dimensionType().ultraWarm()) {
                level.removeBlock(pos, false);
                return;
            }
            BlockState belowState = level.getBlockState(pos.below());
            if (belowState.blocksMotion() || belowState.liquid()) {
                level.setBlockAndUpdate(pos, ((LiquidBlock)TFCBlocks.SALT_WATER.get()).defaultBlockState());
            }
        }
    }

    protected void melt(BlockState state, Level level, BlockPos pos) {
        if (level.dimensionType().ultraWarm()) {
            level.removeBlock(pos, false);
        } else {
            level.setBlockAndUpdate(pos, ((LiquidBlock)TFCBlocks.SALT_WATER.get()).defaultBlockState());
            level.neighborChanged(pos, (Block)TFCBlocks.SALT_WATER.get(), pos);
        }
    }
}

