/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Arrays;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StainedWattleBlock
extends ExtendedBlock
implements IGhostBlockHandler {
    public static final BooleanProperty TOP = TFCBlockStateProperties.TOP;
    public static final BooleanProperty BOTTOM = TFCBlockStateProperties.BOTTOM;
    public static final BooleanProperty LEFT = TFCBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = TFCBlockStateProperties.RIGHT;
    private static final double TOP_LIMIT = 0.75;
    private static final double BOTTOM_LIMIT = 0.25;
    private static final double MIDDLE = 0.5;

    @Nullable
    private static BlockState getStateFor(BlockState state, Direction lookDirection, double x, double y, double z) {
        double horizontal;
        if (lookDirection.getAxis() == Direction.Axis.Y) {
            return null;
        }
        double d = horizontal = lookDirection.getAxis() == Direction.Axis.Z ? x : z;
        if (y > 0.75 && !((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(true));
        }
        if (y < 0.25 && !((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
            return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true));
        }
        if (horizontal < 0.5 && !((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
            return (BlockState)state.setValue((Property)LEFT, (Comparable)Boolean.valueOf(true));
        }
        if (horizontal > 0.5 && !((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
            return (BlockState)state.setValue((Property)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    @Nullable
    private static BlockState removeStateFor(BlockState state, Direction lookDirection, double x, double y, double z) {
        double horizontal;
        if (lookDirection.getAxis() == Direction.Axis.Y) {
            return null;
        }
        double d = horizontal = lookDirection.getAxis() == Direction.Axis.Z ? x : z;
        if (y > 0.75 && ((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false));
        }
        if (y < 0.25 && ((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
            return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
        }
        if (horizontal < 0.5 && ((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
            return (BlockState)state.setValue((Property)LEFT, (Comparable)Boolean.valueOf(false));
        }
        if (horizontal > 0.5 && ((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
            return (BlockState)state.setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @Nullable
    private static BlockState getPossibleDyedState(ItemStack item, BlockState current) {
        BlockState found = Arrays.stream(Helpers.DYE_COLORS).filter(color -> Helpers.isItem(item, (ItemLike)DyeItem.byColor((DyeColor)color))).map(color -> ((Block)TFCBlocks.STAINED_WATTLE.get(color).get()).defaultBlockState()).findFirst().orElse(null);
        return found != null && found.getBlock() != current.getBlock() ? found : null;
    }

    public StainedWattleBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack item = player.getItemInHand(hand);
        if (item.isEmpty() && player.isShiftKeyDown()) {
            return this.tryTakeStick(state, level, pos, player, item, hitResult);
        }
        if (Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN)) {
            return this.tryAddStick(state, level, pos, player, item, hitResult);
        }
        if (Helpers.isBlock(state, (Block)TFCBlocks.WATTLE.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockState dyed = StainedWattleBlock.getPossibleDyedState(item, state);
        if (dyed != null) {
            if (level.isClientSide) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 loc = hitResult.getLocation();
                    level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), loc.x, loc.y, loc.z, (double)(Helpers.triangle(level.random) / 3.0f), (double)(Helpers.triangle(level.random) / 3.0f), (double)(Helpers.triangle(level.random) / 3.0f));
                }
            }
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_DYED.get());
            dyed = (BlockState)((BlockState)((BlockState)((BlockState)dyed.setValue((Property)BOTTOM, (Comparable)((Boolean)state.getValue((Property)BOTTOM)))).setValue((Property)TOP, (Comparable)((Boolean)state.getValue((Property)TOP)))).setValue((Property)LEFT, (Comparable)((Boolean)state.getValue((Property)LEFT)))).setValue((Property)RIGHT, (Comparable)((Boolean)state.getValue((Property)RIGHT)));
            return this.setState(level, pos, dyed, player, item, 1);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState state, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        if (item.isEmpty() && player.isShiftKeyDown()) {
            return StainedWattleBlock.removeStateFor(state, direction, x, y, z);
        }
        if (Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN)) {
            return StainedWattleBlock.getStateFor(state, direction, x, y, z);
        }
        if (Helpers.isBlock(state, (Block)TFCBlocks.WATTLE.get())) {
            return null;
        }
        BlockState dyed = StainedWattleBlock.getPossibleDyedState(item, state);
        if (dyed != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)dyed.setValue((Property)BOTTOM, (Comparable)((Boolean)state.getValue((Property)BOTTOM)))).setValue((Property)TOP, (Comparable)((Boolean)state.getValue((Property)TOP)))).setValue((Property)LEFT, (Comparable)((Boolean)state.getValue((Property)LEFT)))).setValue((Property)RIGHT, (Comparable)((Boolean)state.getValue((Property)RIGHT)));
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TOP, BOTTOM, LEFT, RIGHT}));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.canSurvive(state, (LevelReader)level, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.getBlockState(pos.below()).canBeReplaced();
    }

    protected ItemInteractionResult tryAddStick(BlockState state, Level level, BlockPos pos, Player player, ItemStack item, BlockHitResult hit) {
        Vec3 location = hit.getLocation();
        BlockState placeState = StainedWattleBlock.getStateFor(state, hit.getDirection(), location.x - (double)pos.getX(), location.y - (double)pos.getY(), location.z - (double)pos.getZ());
        if (placeState != null) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, placeState, player, item, 1);
        }
        return ItemInteractionResult.FAIL;
    }

    protected ItemInteractionResult tryTakeStick(BlockState state, Level level, BlockPos pos, Player player, ItemStack item, BlockHitResult hit) {
        Vec3 location = hit.getLocation();
        BlockState placeState = StainedWattleBlock.removeStateFor(state, hit.getDirection(), location.x - (double)pos.getX(), location.y - (double)pos.getY(), location.z - (double)pos.getZ());
        if (placeState != null) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)Items.STICK.getDefaultInstance());
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, placeState, player, item, 0);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult setState(Level level, BlockPos pos, BlockState state, Player player, ItemStack item, int toShrink) {
        if (!player.isCreative()) {
            item.shrink(toShrink);
        }
        level.setBlockAndUpdate(pos, state);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

