/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMagmaBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class TFCBubbleColumnBlock
extends BubbleColumnBlock {
    private final Supplier<? extends Fluid> fluid;

    public static void updateColumnForFluid(LevelAccessor level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        BlockPos.MutableBlockPos cursor = abovePos.mutable();
        BlockState beforeState = aboveState;
        while (TFCBubbleColumnBlock.canExistIn(beforeState)) {
            if (!level.setBlock((BlockPos)cursor, TFCBubbleColumnBlock.getColumnState(beforeState), 2)) {
                return;
            }
            cursor.move(Direction.UP);
            beforeState = level.getBlockState((BlockPos)cursor);
        }
    }

    public static boolean canExistIn(BlockState state) {
        return state.getBlock() instanceof TFCBubbleColumnBlock || FluidHelpers.isAirOrEmptyFluid(state) && TFCBubbleColumnBlock.canExistIn(state.getFluidState().getType());
    }

    public static boolean canExistIn(Fluid fluid) {
        return fluid == Fluids.WATER.getSource() || fluid == TFCFluids.SALT_WATER.getSource();
    }

    public static BlockState getColumnState(BlockState state) {
        return (state.getFluidState().getType() == Fluids.WATER.getSource() ? (Block)TFCBlocks.FRESHWATER_BUBBLE_COLUMN.get() : (Block)TFCBlocks.SALTWATER_BUBBLE_COLUMN.get()).defaultBlockState();
    }

    public TFCBubbleColumnBlock(BlockBehaviour.Properties properties, Supplier<? extends Fluid> fluid) {
        super(properties);
        this.fluid = fluid;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!Helpers.isEntity(entity, TFCTags.Entities.BUBBLE_COLUMN_IMMUNE)) {
            super.entityInside(state, level, pos, entity);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TFCBubbleColumnBlock.updateColumnForFluid((LevelAccessor)level, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return this.getFluid().defaultFluidState();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick((BlockState)state.setValue((Property)DRAG_DOWN, (Comparable)Boolean.valueOf(false)), level, pos, random);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Fluid fluid = this.getFluid();
        level.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)level));
        if (!state.canSurvive((LevelReader)level, pos) || facing == Direction.DOWN || facing == Direction.UP && !(facingState.getBlock() instanceof TFCBubbleColumnBlock) && TFCBubbleColumnBlock.canExistIn(facingState)) {
            level.scheduleTick(pos, (Block)this, 5);
        }
        return state;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return below.getBlock() instanceof TFCBubbleColumnBlock || below.getBlock() instanceof TFCMagmaBlock;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)this.getFluid().getBucket());
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

