/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TFCCakeBlock
extends CakeBlock {
    public static ItemInteractionResult eatCake(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IPlayerInfo.get(player).eat(FoodData.CAKE);
        player.awardStat(Stats.EAT_CAKE_SLICE);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public TFCCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof CandleBlockItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            if (TFCCakeBlock.eatCake(level, pos, state, player).consumesAction()) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player.getItemInHand(hand).isEmpty()) {
                return ItemInteractionResult.CONSUME;
            }
        }
        return TFCCakeBlock.eatCake(level, pos, state, player);
    }
}

