/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCCakeBlock;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TFCCandleCakeBlock
extends AbstractCandleBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)TFCCandleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)TFCCandleCakeBlock.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private final ExtendedProperties properties;

    public TFCCandleCakeBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.properties = properties;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(player.getMainHandItem(), (ItemLike)TFCItems.FIRESTARTER.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (hitResult.getLocation().y - (double)hitResult.getBlockPos().getY() > 0.5 && player.getItemInHand(hand).isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            TFCCandleCakeBlock.extinguish((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        ItemInteractionResult res = TFCCakeBlock.eatCake(level, pos, ((Block)TFCBlocks.CAKE.get()).defaultBlockState(), player);
        if (res.consumesAction()) {
            TFCCandleCakeBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return res;
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState faceState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, faceState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return CakeBlock.FULL_CAKE_SIGNAL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TFCCandleBlock.onRandomTick(state, level, pos);
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return this.fakeBlockCodec();
    }
}

