/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.StainedWattleBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class WattleBlock
extends StainedWattleBlock
implements IGhostBlockHandler,
IFluidLoggable {
    public static final BooleanProperty WOVEN = TFCBlockStateProperties.WATTLE_WOVEN;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;

    public WattleBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)WOVEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.EMPTY)));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid() != Fluids.EMPTY) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack item = player.getItemInHand(hand);
        boolean woven = (Boolean)state.getValue((Property)WOVEN);
        if (!woven && Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN) && item.getCount() >= 4) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_WOVEN.get());
            return this.setState(level, pos, (BlockState)state.setValue((Property)WOVEN, (Comparable)Boolean.valueOf(true)), player, item, 4);
        }
        if (woven && Helpers.isItem(item, TFCItems.DAUB)) {
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.WATTLE_DAUBED.get());
            return this.setState(level, pos, ((Block)TFCBlocks.UNSTAINED_WATTLE.get()).withPropertiesOf(state), player, item, 1);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState lookState, Direction direction, BlockPos lookPos, double x, double y, double z, ItemStack item) {
        if (((FluidProperty.FluidKey)lookState.getValue((Property)this.getFluidProperty())).getFluid() != Fluids.EMPTY) {
            return null;
        }
        boolean woven = (Boolean)lookState.getValue((Property)WOVEN);
        if (!woven && Helpers.isItem(item, (TagKey<Item>)Tags.Items.RODS_WOODEN) && item.getCount() >= 4) {
            return (BlockState)lookState.setValue((Property)WOVEN, (Comparable)Boolean.valueOf(true));
        }
        if (woven && Helpers.isItem(item, TFCItems.DAUB)) {
            return ((Block)TFCBlocks.UNSTAINED_WATTLE.get()).withPropertiesOf(lookState);
        }
        return super.getStateToDraw(level, player, lookState, direction, lookPos, x, y, z, item);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        if (this.getFluidProperty().canContain(fluidState.getType())) {
            return (BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.getType()));
        }
        return this.defaultBlockState();
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WOVEN, this.getFluidProperty()}));
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)WOVEN) != false ? super.getCollisionShape(state, level, pos, context) : Shapes.empty();
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)WOVEN) != false ? super.getOcclusionShape(state, level, pos) : Shapes.empty();
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        super.fallOn(level, state, pos, entity, distance);
        if (distance > 3.0f) {
            level.destroyBlock(pos, true);
        }
    }
}

