/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.data.Fertilizer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class CropHelpers {
    public static final long UPDATE_INTERVAL = 48000L;
    public static final float GROWTH_FACTOR = 1.7361111E-6f;
    public static final float NUTRIENT_CONSUMPTION = 3.4722223E-6f;
    public static final float NUTRIENT_GROWTH_FACTOR = 0.5f;
    public static final float GROWTH_LIMIT = 1.0f;
    public static final float EXPIRY_LIMIT = 2.0f;
    public static final float YIELD_MIN = 0.2f;
    public static final float YIELD_LIMIT = 1.0f;

    public static boolean lightValid(Level level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 12;
    }

    public static boolean growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        long firstTick = crop.getLastGrowthTick();
        long thisTick = Calendars.SERVER.getTicks();
        long lastTick = firstTick;
        for (long tick = firstTick + 48000L; tick < thisTick; tick += 48000L) {
            if (!CropHelpers.growthTickStep(level, pos, state, level.getRandom(), lastTick, tick, crop)) {
                return false;
            }
            lastTick = tick;
        }
        return lastTick >= thisTick || CropHelpers.growthTickStep(level, pos, state, level.getRandom(), lastTick, thisTick, crop);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean growthTickStep(Level level, BlockPos pos, BlockState state, RandomSource random, long fromTick, long toTick, CropBlockEntity crop) {
        calendar = Calendars.get((LevelReader)level);
        sourcePos = pos.below();
        firstCalendarTick = calendar.getCalendarTicks() + calendar.getFixedCalendarTicksFromTick(fromTick - calendar.getTicks());
        secondCalendarTick = calendar.getCalendarTicks() + calendar.getFixedCalendarTicksFromTick(toTick - calendar.getTicks());
        startTemperature = Climate.getTemperature(level, pos, calendar, firstCalendarTick);
        endTemperature = Climate.getTemperature(level, pos, calendar, secondCalendarTick);
        tickDelta = toTick - fromTick;
        cropBlock = (ICropBlock)state.getBlock();
        range = cropBlock.getClimateRange();
        growing = CropHelpers.checkClimate(range, startHydration = FarmlandBlock.getHydration(level, sourcePos, fromTick), endHydration = FarmlandBlock.getHydration(level, sourcePos, toTick), startTemperature, endTemperature, false);
        healthy = growing != false || CropHelpers.checkClimate(range, startHydration, endHydration, startTemperature, endTemperature, true) != false;
        nForGrowth = cropBlock.getNForGrowth();
        pForGrowth = cropBlock.getPForGrowth();
        kForGrowth = cropBlock.getKForGrowth();
        posNForGrowth = Math.max(0.0f, nForGrowth);
        posPForGrowth = Math.max(0.0f, pForGrowth);
        posKForGrowth = Math.max(0.0f, kForGrowth);
        nutrientsForGrowth = posNForGrowth + posPForGrowth + posKForGrowth;
        nRequired = 3.4722223E-6f * (float)tickDelta * nForGrowth;
        pRequired = 3.4722223E-6f * (float)tickDelta * pForGrowth;
        kRequired = 3.4722223E-6f * (float)tickDelta * kForGrowth;
        nutrientsRequired = Math.max(0.0f, nRequired) + Math.max(0.0f, pRequired) + Math.max(0.0f, kRequired);
        nutrientsConsumed = 0.0f;
        nutrientsAvailable = 0.0f;
        var39_33 = level.getBlockEntity(sourcePos);
        if (!(var39_33 instanceof IFarmland)) ** GOTO lbl-1000
        farmland = (IFarmland)var39_33;
        if (nutrientsForGrowth > 0.0f) {
            nutrientsAvailable = Math.min(posNForGrowth, farmland.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN)) + Math.min(posPForGrowth, farmland.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS)) + Math.min(posKForGrowth, farmland.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM));
            maxNToConsume = nForGrowth - crop.getNAbsorbed();
            maxPToConsume = pForGrowth - crop.getPAbsorbed();
            maxKToConsume = kForGrowth - crop.getKAbsorbed();
            nConsumed = farmland.consumeNutrients(Math.min(nRequired, maxNToConsume), FarmlandBlockEntity.NutrientType.NITROGEN);
            pConsumed = farmland.consumeNutrients(Math.min(pRequired, maxPToConsume), FarmlandBlockEntity.NutrientType.PHOSPHOROUS);
            kConsumed = farmland.consumeNutrients(Math.min(kRequired, maxKToConsume), FarmlandBlockEntity.NutrientType.POTASSIUM);
            crop.addNutrients(nConsumed, pConsumed, kConsumed);
            nutrientsConsumed += nConsumed + pConsumed + kConsumed;
        } else lbl-1000:
        // 2 sources

        {
            nutrientsForGrowth = 1.0f;
        }
        growthModifier = TFCConfig.SERVER.cropGrowthModifier.get().floatValue();
        expiryModifier = TFCConfig.SERVER.cropExpiryModifier.get().floatValue();
        localExpiryLimit = 2.0f * expiryModifier * (1.0f / growthModifier);
        totalGrowthDelta = 1.0f / growthModifier * Helpers.uniform(random, 0.9f, 1.1f) * (float)tickDelta * 1.7361111E-6f + nutrientsConsumed / nutrientsForGrowth * 0.5f;
        initialGrowth = crop.getGrowth();
        remainingGrowthDelta = totalGrowthDelta;
        growth = initialGrowth;
        expiry = crop.getExpiry();
        actualYield = crop.getYield();
        expiry *= localExpiryLimit / 2.0f;
        growthLimit = cropBlock.getGrowthLimit(level, pos, state);
        if (remainingGrowthDelta > 0.0f && growing && growth < growthLimit) {
            delta = Math.min(remainingGrowthDelta, growthLimit - growth);
            growth += delta;
            remainingGrowthDelta -= delta;
        }
        if (remainingGrowthDelta > 0.0f) {
            delta = Math.min(remainingGrowthDelta, localExpiryLimit - expiry);
            expiry += delta;
        }
        growthDelta = growth - initialGrowth;
        var50_47 = level.getBlockEntity(sourcePos);
        if (var50_47 instanceof IFarmland) {
            farmland = (IFarmland)var50_47;
            percentOfNutrientsSatisfied = nutrientsRequired > 0.0f ? nutrientsConsumed / nutrientsRequired : 0.0f;
            bonus = CropHelpers.getSoilModifier(level.getBlockState(sourcePos));
            farmland.produceNutrients(nForGrowth * bonus, FarmlandBlockEntity.NutrientType.NITROGEN, percentOfNutrientsSatisfied, growthDelta);
            farmland.produceNutrients(pForGrowth * bonus, FarmlandBlockEntity.NutrientType.PHOSPHOROUS, percentOfNutrientsSatisfied, growthDelta);
            farmland.produceNutrients(kForGrowth * bonus, FarmlandBlockEntity.NutrientType.POTASSIUM, percentOfNutrientsSatisfied, growthDelta);
        }
        nutrientSatisfaction = growthDelta <= 0.0f ? 1.0f : (nutrientsRequired <= 0.0f ? 0.0f : Math.min(1.0f, totalGrowthDelta / growthDelta * (nutrientsAvailable / nutrientsRequired)));
        actualYield += growthDelta * Helpers.lerp(nutrientSatisfaction, 0.2f, 1.0f);
        if (expiry >= localExpiryLimit || !healthy) {
            cropBlock.die(level, pos, state, growth >= 1.0f);
            return false;
        }
        crop.setGrowth(growth);
        crop.setYield(actualYield);
        crop.setExpiry(expiry *= 2.0f / localExpiryLimit);
        crop.setLastGrowthTick(calendar.getTicks());
        return true;
    }

    private static boolean checkClimate(ClimateRange range, int firstHydration, int secondHydration, float firstTemperature, float secondTemperature, boolean allowWiggle) {
        return range.checkBoth(firstHydration, firstTemperature, allowWiggle) && range.checkBoth(secondHydration, secondTemperature, allowWiggle);
    }

    public static boolean useFertilizer(Level level, Player player, InteractionHand hand, BlockPos farmlandPos) {
        BlockEntity blockEntity;
        ItemStack stack = player.getItemInHand(hand);
        Fertilizer fertilizer = Fertilizer.get(stack);
        if (fertilizer != null && (blockEntity = level.getBlockEntity(farmlandPos)) instanceof IFarmland) {
            IFarmland farmland = (IFarmland)blockEntity;
            if (!level.isClientSide()) {
                float bonus = CropHelpers.getSoilModifier(level.getBlockState(farmlandPos));
                int repeat = -1;
                if (player.isShiftKeyDown()) {
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.NITROGEN, repeat, bonus);
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.POTASSIUM, repeat, bonus);
                    repeat = CropHelpers.minAmountRequiredToNextFillBar(farmland, fertilizer, FarmlandBlockEntity.NutrientType.PHOSPHOROUS, repeat, bonus);
                    repeat = Math.min(repeat, stack.getCount());
                }
                if (repeat == -1) {
                    repeat = 1;
                }
                if (!(fertilizer.nitrogen() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.NITROGEN) != 1.0f || fertilizer.potassium() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.POTASSIUM) != 1.0f || fertilizer.phosphorus() != 0.0f && farmland.getNutrient(FarmlandBlockEntity.NutrientType.PHOSPHOROUS) != 1.0f)) {
                    return false;
                }
                farmland.addNutrients(fertilizer, (float)repeat * bonus);
                if (!player.isCreative()) {
                    stack.shrink(repeat);
                }
                IFarmland.addNutrientParticles((ServerLevel)level, farmlandPos.above(), fertilizer);
                Helpers.playSound(level, farmlandPos, (SoundEvent)TFCSounds.FERTILIZER_USE.get());
                if (farmland.isMaxedOut() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.FULL_FERTILIZER.trigger(serverPlayer);
                }
            }
            return true;
        }
        return false;
    }

    public static float getSoilModifier(BlockState state) {
        if (Helpers.isBlock(state, TFCTags.Blocks.VERY_RICH_FARMLAND)) {
            return 1.2f;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.RICH_FARMLAND)) {
            return 1.1f;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.POOR_FARMLAND)) {
            return 0.9f;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.VERY_POOR_FARMLAND)) {
            return 0.8f;
        }
        return 1.0f;
    }

    private static int minAmountRequiredToNextFillBar(IFarmland farmland, Fertilizer fertilizer, FarmlandBlockEntity.NutrientType type, int prevValue, float bonus) {
        float amount = fertilizer.getNutrient(type) * bonus;
        if (amount > 0.0f && farmland.getNutrient(type) < 1.0f) {
            int requiredValue = Mth.ceil((float)((1.0f - farmland.getNutrient(type)) / amount));
            if (prevValue == -1 || requiredValue < prevValue) {
                return requiredValue;
            }
        }
        return prevValue;
    }
}

