/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DefaultCropBlock
extends CropBlock {
    public static DefaultCropBlock create(ExtendedProperties properties, int stages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(stages - 1);
        return new DefaultCropBlock(properties, stages - 1, TFCBlocks.DEAD_CROPS.get((Object)crop), TFCItems.CROP_SEEDS.get((Object)crop), crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty getAgeProperty() {
                return property;
            }
        };
    }

    protected DefaultCropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosphorous, float potassium, Supplier<ClimateRange> climateRange) {
        super(properties, maxAge, dead, seeds, nitrogen, phosphorous, potassium, climateRange);
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockState deadState = (BlockState)((Block)this.dead.get()).defaultBlockState().setValue((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown));
        level.setBlockAndUpdate(pos, deadState);
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        int age = crop.getGrowth() == 1.0f ? this.getMaxAge() : (int)(crop.getGrowth() * (float)this.getMaxAge());
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age)));
    }
}

