/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.ISpecialPile;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WildCropBlock
extends TFCBushBlock
implements ISpecialPile {
    public static final BooleanProperty MATURE = TFCBlockStateProperties.MATURE;

    public static boolean isMature(Level level, BlockPos pos) {
        int month = Calendars.get((LevelReader)level).getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, level)).ordinal();
        return month >= Month.JUNE.ordinal() && month <= Month.OCTOBER.ordinal();
    }

    public WildCropBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MATURE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)MATURE, (Comparable)Boolean.valueOf(WildCropBlock.isMature(context.getLevel(), context.getClickedPos())));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if ((Boolean)state.getValue((Property)MATURE) != WildCropBlock.isMature((Level)level, pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)MATURE));
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CropBlock.FULL_SHAPE;
    }

    @Override
    public BlockState getHiddenState(BlockState internalState, boolean byPlayer) {
        return (BlockState)internalState.setValue((Property)MATURE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    @Nullable
    public BlockState getHiddenStateAbove(@Nullable BlockState aboveState, boolean byPlayer) {
        return aboveState != null && aboveState.hasProperty((Property)MATURE) ? (BlockState)aboveState.setValue((Property)MATURE, (Comparable)Boolean.valueOf(false)) : aboveState;
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos), TFCTags.Blocks.GRASS_PLANTABLE_ON);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.WILD_CROP_GROWS_ON);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{MATURE}));
    }
}

