/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.HorizontalPipeBlock;
import net.dries007.tfc.common.blocks.crop.WildCropBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WildSpreadingCropBlock
extends WildCropBlock
implements HorizontalPipeBlock {
    private final Supplier<Supplier<? extends Block>> fruit;

    @Nullable
    public static BlockState updateBlockState(Level level, BlockPos pos, @Nullable BlockState state, Block fruit) {
        if (state != null) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(level.getBlockState(pos.relative(dir)).getBlock() == fruit));
            }
        }
        return state;
    }

    public WildSpreadingCropBlock(ExtendedProperties properties, Supplier<Supplier<? extends Block>> fruit) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false)));
        this.fruit = fruit;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return WildSpreadingCropBlock.updateBlockState(context.getLevel(), context.getClickedPos(), super.getStateForPlacement(context), this.fruit.get().get());
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        state = super.updateShape(state, facing, facingState, level, pos, facingPos);
        return Helpers.setProperty(state, (Property)PROPERTY_BY_DIRECTION.get(facing), facingState.getBlock() == this.fruit.get().get());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{NORTH, SOUTH, EAST, WEST}));
    }

    public Block getFruit() {
        return this.fruit.get().get();
    }
}

