/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.Tiered;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AnvilBlock
extends DeviceBlock
implements Tiered {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_X = AnvilBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape SHAPE_Z = AnvilBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)11.0, (double)16.0);
    private final int tier;

    public static ItemInteractionResult interactWithAnvil(Level level, BlockPos pos, Player player, InteractionHand hand) {
        AnvilBlockEntity anvil = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.ANVIL.get()).orElse(null);
        if (anvil == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Object inventory = anvil.getInventory();
        if (player.isShiftKeyDown()) {
            ItemStack playerStack = player.getItemInHand(hand);
            if (playerStack.isEmpty()) {
                for (int slot : AnvilBlockEntity.SLOTS_BY_HAND_EXTRACT) {
                    ItemStack anvilStack = inventory.getStackInSlot(slot);
                    if (anvilStack.isEmpty()) continue;
                    ItemStack result = inventory.extractItem(slot, 1, false);
                    player.setItemInHand(hand, result);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else {
                if (Helpers.isItem(playerStack, TFCTags.Items.TOOLS_HAMMER)) {
                    InteractionResult weld = anvil.weld(player);
                    if (weld.consumesAction()) {
                        if (level instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            double x = (double)pos.getX() + Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.8);
                            double z = (double)pos.getZ() + Mth.nextDouble((RandomSource)level.random, (double)0.2, (double)0.8);
                            double y = (double)pos.getY() + Mth.nextDouble((RandomSource)level.random, (double)0.8, (double)1.0);
                            server.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.SPARK.get()), x, y, z, 8, 0.0, 0.0, 0.0, (double)0.2f);
                        }
                        level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.PLAYERS, 0.6f, 1.0f);
                    }
                    return weld == InteractionResult.PASS ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                ItemStack insertStack = playerStack.copy();
                for (int slot : AnvilBlockEntity.SLOTS_BY_HAND_INSERT) {
                    ItemStack resultStack = inventory.insertItem(slot, insertStack, false);
                    if (insertStack.getCount() <= resultStack.getCount()) continue;
                    player.setItemInHand(hand, resultStack);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        } else {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu(anvil.anvilProvider(), pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public AnvilBlock(ExtendedProperties properties, int tier) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.tier = tier;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return AnvilBlock.interactWithAnvil(level, pos, player, hand);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

