/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BellowsBlock
extends DeviceBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape[] COMPLETE_SHAPES = Helpers.computeHorizontalShapes(d -> BellowsBlock.createShapeFor(d, 0.875f));
    private final ExtendedProperties properties;

    private static VoxelShape createShapeFor(Direction direction, float extension) {
        return Shapes.or((VoxelShape)BellowsBlock.makeFrontShape(direction), (VoxelShape[])new VoxelShape[]{BellowsBlock.makeMiddleShape(direction, extension), BellowsBlock.makeEndShape(direction, extension)});
    }

    private static VoxelShape makeFrontShape(Direction direction) {
        return Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    }

    private static VoxelShape makeMiddleShape(Direction direction, float extension) {
        return Helpers.rotateShape(direction, 2.0, 2.0, 2.0, 14.0, 14.0, extension * 16.0f);
    }

    private static VoxelShape makeEndShape(Direction direction, float extension) {
        return Helpers.rotateShape(direction, 0.0, 0.0, extension * 16.0f, 16.0, 16.0, extension * 16.0f + 2.0f);
    }

    public BellowsBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BELLOWS.get()).map(bellows -> {
            float ext = 1.0f - bellows.getExtensionLength(1.0f);
            return ext == 0.875f ? COMPLETE_SHAPES[direction.get2DDataValue()] : BellowsBlock.createShapeFor(direction, ext);
        }).orElse(COMPLETE_SHAPES[direction.get2DDataValue()]);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        boolean isShifting = context.getPlayer() != null && context.getPlayer().isShiftKeyDown();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(isShifting ? direction : direction.getOpposite()));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        level.scheduleTick(pos, (Block)this, 2);
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BELLOWS.get()).map(BellowsBlockEntity::onRightClick).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

