/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlastFurnaceBlock
extends DeviceBlock
implements IBellowsConsumer {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final MultiBlock BLAST_FURNACE_CHIMNEY = new MultiBlock().match(new BlockPos(0, 0, 0), state -> state.isAir() || Helpers.isBlock(state, (Block)TFCBlocks.MOLTEN.get())).match(new BlockPos(0, 0, 1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(0, 0, -1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(1, 0, 0), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(-1, 0, 0), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(1, 0, 1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(1, 0, -1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(-1, 0, -1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(-1, 0, 1), TFCTags.Blocks.BLAST_FURNACE_INSULATION);

    public static boolean isBlastFurnaceInsulationBlock(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.BLAST_FURNACE_INSULATION);
    }

    public static int getChimneyLevels(Level level, BlockPos pos) {
        int maxHeight = TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get();
        for (int i = 0; i < maxHeight; ++i) {
            BlockPos center = pos.above(i + 1);
            if (BLAST_FURNACE_CHIMNEY.test((LevelAccessor)level, center)) continue;
            return i;
        }
        return maxHeight;
    }

    public BlastFurnaceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlastFurnaceBlockEntity blastFurnace = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).orElse(null);
        if (blastFurnace != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)blastFurnace, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public boolean canAcceptAir(Level level, BlockPos pos, BlockState state) {
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).map(BlastFurnaceBlockEntity::hasTuyere).orElse(false);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (random.nextDouble() < 0.1) {
            level.playLocalSound(x, y, z, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).ifPresent(blastFurnace -> blastFurnace.intakeAir(amount));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{LIT}));
    }
}

