/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.EnumMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BloomeryBlock
extends DeviceBlock
implements EntityBlockExtension {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final VoxelShape OPEN_NORTH_SHAPE = Shapes.or((VoxelShape)BloomeryBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), BloomeryBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)8.0), BloomeryBlock.box((double)14.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)8.0)});
    public static final VoxelShape OPEN_SOUTH_SHAPE = Shapes.or((VoxelShape)BloomeryBlock.box((double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), BloomeryBlock.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)15.0, (double)15.0), BloomeryBlock.box((double)14.0, (double)1.0, (double)8.0, (double)16.0, (double)15.0, (double)15.0)});
    public static final VoxelShape OPEN_WEST_SHAPE = Shapes.or((VoxelShape)BloomeryBlock.box((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), BloomeryBlock.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), BloomeryBlock.box((double)1.0, (double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0), BloomeryBlock.box((double)1.0, (double)1.0, (double)14.0, (double)8.0, (double)15.0, (double)16.0)});
    public static final VoxelShape OPEN_EAST_SHAPE = Shapes.or((VoxelShape)BloomeryBlock.box((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), BloomeryBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), BloomeryBlock.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), BloomeryBlock.box((double)8.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0), BloomeryBlock.box((double)8.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0)});
    public static final VoxelShape CLOSED_NORTH_SHAPE = BloomeryBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape CLOSED_SOUTH_SHAPE = BloomeryBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST_SHAPE = BloomeryBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST_SHAPE = BloomeryBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final MultiBlock BLOOMERY_CHIMNEY;
    private static final EnumMap<Direction, MultiBlock> BASE_MULTIBLOCKS;
    private static final MultiBlock GATE_Z;
    private static final MultiBlock GATE_X;
    private static final Direction[] NORTH_SOUTH_DOWN;
    private static final Direction[] EAST_WEST_DOWN;

    public static boolean isBloomeryInsulationBlock(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.BLOOMERY_INSULATION);
    }

    public static int getChimneyLevels(Level level, BlockPos centerPos) {
        for (int i = 1; i < 1 + TFCConfig.SERVER.bloomeryMaxChimneyHeight.get(); ++i) {
            BlockPos center = centerPos.above(i);
            if (BLOOMERY_CHIMNEY.test((LevelAccessor)level, center)) continue;
            return i - 1;
        }
        return TFCConfig.SERVER.bloomeryMaxChimneyHeight.get();
    }

    public static boolean canGateStayInPlace(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return GATE_X.test(level, pos);
        }
        return GATE_Z.test(level, pos);
    }

    public static boolean isFormed(Level level, BlockPos centerPos, Direction facing) {
        return facing.getAxis() != Direction.Axis.Y && BASE_MULTIBLOCKS.get(facing).test((LevelAccessor)level, centerPos);
    }

    public BloomeryBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (random.nextDouble() < 0.1) {
            level.playLocalSound(x, y, z, (SoundEvent)TFCSounds.BLOOMERY_CRACKLE.get(), SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            state = (BlockState)state.cycle((Property)OPEN);
            level.setBlockAndUpdate(pos, state);
            Helpers.playSound(level, pos, (Boolean)state.getValue((Property)OPEN) != false ? SoundEvents.FENCE_GATE_OPEN : SoundEvents.FENCE_GATE_CLOSE);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return BloomeryBlock.canGateStayInPlace(level, pos, ((Direction)state.getValue((Property)FACING)).getAxis()) ? state : Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction placeDirection = null;
        for (Direction d : context.getNearestLookingDirections()) {
            if (d.getAxis() == Direction.Axis.Y || !BloomeryBlock.canGateStayInPlace((LevelAccessor)context.getLevel(), context.getClickedPos(), d.getAxis())) continue;
            placeDirection = d;
            break;
        }
        if (placeDirection == null) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placeDirection.getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}).add(new Property[]{LIT}).add(new Property[]{OPEN}));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.NORTH -> OPEN_NORTH_SHAPE;
                case Direction.SOUTH -> OPEN_SOUTH_SHAPE;
                case Direction.WEST -> OPEN_WEST_SHAPE;
                case Direction.EAST -> OPEN_EAST_SHAPE;
                default -> throw new IllegalArgumentException("Bloomery has no facing direction");
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> CLOSED_NORTH_SHAPE;
            case Direction.SOUTH -> CLOSED_SOUTH_SHAPE;
            case Direction.WEST -> CLOSED_WEST_SHAPE;
            case Direction.EAST -> CLOSED_EAST_SHAPE;
            default -> throw new IllegalArgumentException("Bloomery has no facing direction");
        };
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!Helpers.isBlock(state, newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof BloomeryBlockEntity) {
            BloomeryBlockEntity bloomery = (BloomeryBlockEntity)blockEntity;
            bloomery.ejectInventory();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    static {
        NORTH_SOUTH_DOWN = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.DOWN};
        EAST_WEST_DOWN = new Direction[]{Direction.EAST, Direction.WEST, Direction.DOWN};
        BiPredicate<LevelAccessor, BlockPos> stoneMatcher = (level, pos) -> BloomeryBlock.isBloomeryInsulationBlock(level.getBlockState(pos));
        Predicate<BlockState> insideChimney = state -> state.getBlock() == TFCBlocks.MOLTEN.get() || state.isAir();
        Predicate<BlockState> center = state -> Helpers.isBlock(state, (Block)TFCBlocks.MOLTEN.get()) || Helpers.isBlock(state, (Block)TFCBlocks.BLOOM.get()) || state.isAir();
        BlockPos origin = BlockPos.ZERO;
        BASE_MULTIBLOCKS = new EnumMap(Direction.class);
        MultiBlock commonMultiblock = new MultiBlock().match(origin, center).match(origin.below(), stoneMatcher);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BASE_MULTIBLOCKS.put(d, commonMultiblock.copy().match(origin.relative(d), state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get())).matchEachDirection(origin, stoneMatcher, (Direction[])Direction.Plane.HORIZONTAL.stream().filter(direction -> direction != d).toArray(Direction[]::new), 1).matchEachDirection(origin.relative(d), stoneMatcher, d.getAxis() == Direction.Axis.Z ? EAST_WEST_DOWN : NORTH_SOUTH_DOWN, 1).matchHorizontal(origin.above(), stoneMatcher, 1));
        }
        BLOOMERY_CHIMNEY = new MultiBlock().match(origin, insideChimney).matchHorizontal(origin, stoneMatcher, 1);
        GATE_Z = new MultiBlock().match(origin, state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get()) || state.isAir()).matchEachDirection(origin, stoneMatcher, new Direction[]{Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN}, 1);
        GATE_X = new MultiBlock().match(origin, state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get()) || state.isAir()).matchEachDirection(origin, stoneMatcher, new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN}, 1);
    }
}

