/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BottomSupportedDeviceBlock
extends DeviceBlock {
    private final VoxelShape shape;

    public static boolean canSurvive(LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState state = level.getBlockState(below);
        return state.isFaceSturdy((BlockGetter)level, below, Direction.UP) || Helpers.isBlock(state, TFCTags.Blocks.SOLID_TOP_FACE);
    }

    protected BottomSupportedDeviceBlock(ExtendedProperties properties, DeviceBlock.InventoryRemoveBehavior removeBehavior) {
        this(properties, removeBehavior, Shapes.block());
    }

    protected BottomSupportedDeviceBlock(ExtendedProperties properties, DeviceBlock.InventoryRemoveBehavior removeBehavior, VoxelShape shape) {
        super(properties, removeBehavior);
        this.shape = shape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BottomSupportedDeviceBlock.canSurvive(level, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return BottomSupportedDeviceBlock.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? super.getStateForPlacement(context) : null;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !BottomSupportedDeviceBlock.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

