/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BurningLogPileBlockEntity;
import net.dries007.tfc.common.blockentities.LogPileBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.LogPileBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BurningLogPileBlock
extends Block
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_16;
    private static final int TICK_DELAY = 30;
    private final ExtendedProperties properties;

    public static void lightLogPile(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LogPileBlockEntity) {
            LogPileBlockEntity pile = (LogPileBlockEntity)blockEntity;
            int logs = pile.logCount();
            BlockState state = level.getBlockState(pos);
            pile.clearContent();
            level.setBlockAndUpdate(pos, Helpers.copyProperties(((Block)TFCBlocks.BURNING_LOG_PILE.get()).defaultBlockState(), state));
            Helpers.playSound(level, pos, SoundEvents.BLAZE_SHOOT);
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof BurningLogPileBlockEntity) {
                BurningLogPileBlockEntity burningPile = (BurningLogPileBlockEntity)blockEntity2;
                burningPile.light(logs);
                BurningLogPileBlock.tryLightNearby(level, pos);
            }
        }
    }

    public static void tryLightLogPile(Level level, BlockPos pos) {
        if (level.getBlockEntity(pos) instanceof LogPileBlockEntity) {
            level.scheduleTick(pos, level.getBlockState(pos).getBlock(), 30);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS}).add(new Property[]{COUNT}));
    }

    private static boolean isValidCoverBlock(BlockState offsetState, Level level, BlockPos pos, Direction side) {
        if (Helpers.isBlock(offsetState, TFCTags.Blocks.CHARCOAL_PIT_INSULATION)) {
            return true;
        }
        return !offsetState.isFlammable((BlockGetter)level, pos, side) && offsetState.isFaceSturdy((BlockGetter)level, pos, side);
    }

    private static void tryLightNearby(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction side : Helpers.DIRECTIONS) {
            cursor.setWithOffset((Vec3i)pos, side);
            BlockState offsetState = level.getBlockState((BlockPos)cursor);
            if (BurningLogPileBlock.isValidCoverBlock(offsetState, level, (BlockPos)cursor, side.getOpposite())) {
                if (!Helpers.isBlock(offsetState, (Block)TFCBlocks.LOG_PILE.get())) continue;
                BurningLogPileBlock.tryLightLogPile(level, (BlockPos)cursor);
                continue;
            }
            if (offsetState.isAir()) {
                level.setBlockAndUpdate((BlockPos)cursor, Blocks.FIRE.defaultBlockState());
                continue;
            }
            if (level.random.nextInt(7) != 0) continue;
            level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
            return;
        }
    }

    public BurningLogPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BurningLogPileBlock.tryLightNearby((Level)level, pos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (level.getBlockState(pos.above(2)).canBeReplaced()) {
            double x = (float)pos.getX() + rand.nextFloat();
            double y = (double)pos.getY() + 1.125;
            double z = (float)pos.getZ() + rand.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, (double)(0.1f + 0.1f * rand.nextFloat()), 0.0);
            if (rand.nextInt(12) == 0) {
                level.playLocalSound(x, y, z, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, (double)((0.5f - rand.nextFloat()) / 10.0f), (double)(0.1f + rand.nextFloat() / 8.0f), (double)((0.5f - rand.nextFloat()) / 10.0f));
        }
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LogPileBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

