/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class DeviceBlock
extends ExtendedBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final InventoryRemoveBehavior removeBehavior;

    public DeviceBlock(ExtendedProperties properties, InventoryRemoveBehavior removeBehavior) {
        super(properties);
        this.removeBehavior = removeBehavior;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            if (!Helpers.isBlock(state, newState.getBlock())) {
                this.beforeRemove(inv);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity entity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (this.removeBehavior == InventoryRemoveBehavior.SAVE && (entity = level.getBlockEntity(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
            DeviceBlock deviceBlock = this;
            if (deviceBlock instanceof IItemSize) {
                IItemSize size = (IItemSize)((Object)deviceBlock);
                size.modifyWeight(stack);
            }
        }
        return stack;
    }

    protected void beforeRemove(InventoryBlockEntity<?> entity) {
        if (this.removeBehavior == InventoryRemoveBehavior.DROP) {
            entity.ejectInventory();
        }
    }

    protected static enum InventoryRemoveBehavior {
        NOOP,
        DROP,
        SAVE;

    }
}

