/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class IngotPileBlock
extends ExtendedBlock
implements EntityBlockExtension {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_64;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)2.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)4.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)6.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)8.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)10.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)12.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)14.0, (double)15.75), IngotPileBlock.box((double)0.25, (double)0.0, (double)0.25, (double)15.75, (double)16.0, (double)15.75)};

    public IngotPileBlock(ExtendedProperties properties) {
        this(properties, COUNT);
    }

    protected IngotPileBlock(ExtendedProperties properties, IntegerProperty countProperty) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)countProperty, (Comparable)Integer.valueOf(1)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction.getOpposite()) && !Helpers.isBlock(neighborState, this)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown()) {
            BlockPos topPos = pos;
            while (Helpers.isBlock(level.getBlockState(topPos.above()), this)) {
                topPos = topPos.above();
            }
            BlockState topState = level.getBlockState(topPos);
            int topIngots = (Integer)topState.getValue((Property)this.getCountProperty());
            BlockEntity blockEntity = level.getBlockEntity(topPos);
            if (blockEntity instanceof IngotPileBlockEntity) {
                IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
                ItemStack ingot = pile.removeIngot();
                if (!player.isCreative()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ingot);
                }
            }
            if (topIngots == 1) {
                level.removeBlock(topPos, false);
            } else {
                level.setBlock(topPos, (BlockState)topState.setValue((Property)this.getCountProperty(), (Comparable)Integer.valueOf(topIngots - 1)), 2);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos adjacentPos = pos.below();
        BlockState adjacentState = level.getBlockState(adjacentPos);
        return adjacentState.isFaceSturdy((BlockGetter)level, adjacentPos, Direction.UP) || Helpers.isBlock(adjacentState, this);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        boolean canActuallyHarvest = state.canHarvestBlock((BlockGetter)level, pos, player);
        this.playerWillDestroy(level, pos, state, player);
        if (player.isCreative() && canActuallyHarvest && (blockEntity = level.getBlockEntity(pos)) instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
            pile.removeAllIngots(ingot -> {});
        }
        return level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
            if (newState.getBlock() != this) {
                pile.removeAllIngots(ingot -> IngotPileBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)ingot));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{this.getCountProperty()}));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Integer)state.getValue((Property)this.getCountProperty()) - 1) / 8];
    }

    public IntegerProperty getCountProperty() {
        return COUNT;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)blockEntity;
            itemStack = pile.getPickedItemStack();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        return itemStack;
    }
}

