/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.LogPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LogPileBlock
extends DeviceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_16;
    private static final VoxelShape[][] SHAPES_BY_DIR_BY_COUNT = (VoxelShape[][])Util.make((Object)new VoxelShape[2][16], shapes -> {
        double[][] box2ByCount = new double[16][6];
        double[][] box1ByCount = new double[16][6];
        for (int i = 0; i < 16; ++i) {
            int layer = i / 4;
            int row = i % 4 + 1;
            box2ByCount[i] = new double[]{0.0, 4 * layer, 0.0, 16.0, 4 * layer + 4, 4 * row};
            box1ByCount[i] = new double[]{0.0, 0.0, 0.0, 16.0, 4 * layer, 16.0};
        }
        for (int dir = 0; dir < 2; ++dir) {
            Direction direction = Direction.SOUTH;
            if (dir == 1) {
                direction = Direction.EAST;
            }
            for (int count = 0; count < 16; ++count) {
                VoxelShape box1 = Helpers.rotateShape(direction, box1ByCount[count][0], box1ByCount[count][1], box1ByCount[count][2], box1ByCount[count][3], box1ByCount[count][4], box1ByCount[count][5]);
                VoxelShape box2 = Helpers.rotateShape(direction, box2ByCount[count][0], box2ByCount[count][1], box2ByCount[count][2], box2ByCount[count][3], box2ByCount[count][4], box2ByCount[count][5]);
                shapes[dir][count] = Shapes.or((VoxelShape)box1, (VoxelShape)box2);
            }
        }
    });

    public LogPileBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BurningLogPileBlock.lightLogPile((Level)level, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis())).setValue((Property)COUNT, (Comparable)Integer.valueOf(1));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS}).add(new Property[]{COUNT}));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor levelAccess, BlockPos currentPos, BlockPos facingPos) {
        if (!levelAccess.isClientSide() && levelAccess instanceof Level) {
            Level level = (Level)levelAccess;
            if (facing == Direction.DOWN && !facingState.isFaceSturdy((BlockGetter)levelAccess, facingPos, Direction.UP) && !(facingState.getBlock() instanceof LogPileBlock)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (Helpers.isBlock(facingState, (TagKey<Block>)BlockTags.FIRE)) {
                BurningLogPileBlock.lightLogPile(level, currentPos);
            }
        }
        return super.updateShape(state, facing, facingState, levelAccess, currentPos, facingPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof LogPileBlockEntity) {
            LogPileBlockEntity logPile = (LogPileBlockEntity)blockEntity;
            if (Helpers.isItem(stack.getItem(), TFCTags.Items.LOG_PILE_LOGS)) {
                LogPileBlock.insertAndPushUp(stack, state, level, pos, logPile, false);
            } else if (stack.isEmpty()) {
                LogPileBlock.extractFromTop(level, pos, player, false);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void extractFromTop(Level level, BlockPos pos, Player player, boolean all) {
        if (level.getBlockState(pos.above()).is((Block)TFCBlocks.LOG_PILE.get())) {
            LogPileBlock.extractFromTop(level, pos.above(), player, all);
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LogPileBlockEntity) {
                LogPileBlockEntity logPile = (LogPileBlockEntity)blockEntity;
                for (int i = 0; i < 16; ++i) {
                    ItemStack slotStack = ((ItemStackHandler)logPile.getInventory()).getStackInSlot(i);
                    if (slotStack.isEmpty()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)slotStack.split(1));
                    logPile.setAndUpdateSlots(-1);
                    if (!all) break;
                }
            }
        }
    }

    public static void insertAndPushUp(ItemStack stack, BlockState state, Level level, BlockPos pos, LogPileBlockEntity logPile, boolean all) {
        BlockEntity stateAbove;
        LogPileBlockEntity pileAbove;
        if (LogPileBlock.dumbInsert(stack, state, level, pos, logPile, all) && !all) {
            return;
        }
        BlockPos abovePos = pos.above();
        if (level.getBlockState(abovePos).isAir() && logPile.logCount() == 16 && !stack.isEmpty()) {
            level.setBlockAndUpdate(abovePos, (BlockState)((Block)TFCBlocks.LOG_PILE.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS))));
            BlockEntity blockEntity = level.getBlockEntity(abovePos);
            if (blockEntity instanceof LogPileBlockEntity) {
                pileAbove = (LogPileBlockEntity)blockEntity;
                stateAbove = level.getBlockState(abovePos);
                if (LogPileBlock.dumbInsert(stack, (BlockState)stateAbove, level, abovePos, pileAbove, all)) {
                    return;
                }
                level.removeBlock(abovePos, false);
            }
        }
        if (level.getBlockState(abovePos).getBlock() instanceof LogPileBlock && logPile.logCount() == 16 && (stateAbove = level.getBlockEntity(abovePos)) instanceof LogPileBlockEntity) {
            pileAbove = (LogPileBlockEntity)stateAbove;
            stateAbove = level.getBlockState(abovePos);
            LogPileBlock.insertAndPushUp(stack, (BlockState)stateAbove, level, abovePos, pileAbove, all);
        }
    }

    private static boolean dumbInsert(ItemStack stack, BlockState state, Level level, BlockPos pos, LogPileBlockEntity logPile, boolean all) {
        if (all) {
            ItemStack insertStack = stack.copy();
            insertStack = Helpers.insertAllSlots(logPile.getInventory(), insertStack);
            if (insertStack.getCount() < stack.getCount()) {
                Helpers.playPlaceSound(null, (LevelAccessor)level, pos, SoundType.WOOD);
                stack.setCount(insertStack.getCount());
                logPile.setAndUpdateSlots(-1);
                return true;
            }
        } else if (Helpers.insertOne(logPile, stack)) {
            Helpers.playPlaceSound(null, (LevelAccessor)level, pos, state);
            stack.shrink(1);
            logPile.setAndUpdateSlots(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).map(pile -> {
            for (int i = 0; i < ((ItemStackHandler)pile.getInventory()).getSlots(); ++i) {
                ItemStack stack = ((ItemStackHandler)pile.getInventory()).getStackInSlot(i);
                if (stack.isEmpty()) continue;
                return stack.copy();
            }
            return ItemStack.EMPTY;
        }).orElse(ItemStack.EMPTY);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP) || blockstate.getBlock() instanceof LogPileBlock;
    }

    public static VoxelShape getShapeByDirByCount(Direction.Axis axis, int count) {
        --count;
        if (axis == Direction.Axis.X) {
            return SHAPES_BY_DIR_BY_COUNT[0][count];
        }
        return SHAPES_BY_DIR_BY_COUNT[1][count];
    }

    protected VoxelShape getShape(BlockState state, BlockGetter levle, BlockPos pos, CollisionContext context) {
        return LogPileBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LogPileBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LogPileBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }
}

