/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Optional;
import net.dries007.tfc.common.blockentities.MoldBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoldBlock
extends ExtendedBlock
implements EntityBlockExtension,
IBellowsConsumer {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    static final VoxelShape SHAPE = MoldBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    public MoldBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{EAST, SOUTH, WEST, NORTH});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional mold = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get());
            if (mold.isPresent()) {
                return ((MoldBlockEntity)mold.get()).onRightClick((Player)serverPlayer);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        for (Direction neighborDirection : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(neighborDirection);
            BlockState neighborState = level.getBlockState(neighborPos);
            boolean neighborIsChannel = neighborState.getBlock() instanceof ChannelBlock;
            state = (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(neighborDirection), (Comparable)Boolean.valueOf(neighborIsChannel));
        }
        return state;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).ifPresent(channel -> channel.finishFlow());
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).ifPresent(channel -> channel.finishFlow());
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).map(mold -> {
            if (!mold.getOutputStack().isEmpty()) {
                return 15;
            }
            ItemStack moldStack = mold.getMoldStack();
            IMold moldItem = IMold.get(moldStack);
            if (moldItem != null) {
                return 1 + 13 * moldItem.getFluidInTank(0).getAmount() / moldItem.getTankCapacity(0);
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> mold.intakeAir(amount));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != state.getBlock()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.MOLD_TABLE.get()).ifPresent(mold -> {
                Helpers.spawnItem(level, pos, ((MoldBlockEntity.MoldBlockInventory)mold.getInventory()).getStackInSlot(0));
                Helpers.spawnItem(level, pos, ((MoldBlockEntity.MoldBlockInventory)mold.getInventory()).getStackInSlot(1));
            });
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

