/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PitKilnBlock
extends DeviceBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.PIT_KILN_STAGE;
    public static final int STRAW_END = 7;
    public static final int LOG_START = 8;
    public static final int LOG_END = 15;
    public static final int LIT = 16;
    public static final VoxelShape[] SHAPE_BY_LAYER = (VoxelShape[])Util.make((Object)new VoxelShape[17], shapes -> {
        int i;
        for (i = 0; i < 8; ++i) {
            shapes[i] = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
        }
        for (i = 0; i < 4; ++i) {
            shapes[8 + i] = Shapes.or((VoxelShape)shapes[7 + i], (VoxelShape)Block.box((double)(4 * i), (double)8.0, (double)0.0, (double)(4 * (i + 1)), (double)12.0, (double)16.0));
        }
        for (i = 0; i < 4; ++i) {
            shapes[12 + i] = Shapes.or((VoxelShape)shapes[11 + i], (VoxelShape)Block.box((double)(4 * i), (double)12.0, (double)0.0, (double)(4 * (i + 1)), (double)16.0, (double)16.0));
        }
        shapes[16] = Shapes.block();
    });

    public PitKilnBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)STAGE) == 16) {
            double x = (float)pos.getX() + random.nextFloat();
            double y = (float)pos.getY() + random.nextFloat();
            double z = (float)pos.getZ() + random.nextFloat();
            for (int i = 0; i < random.nextInt(3); ++i) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, x, y, z, 0.0, (double)(0.1f + random.nextFloat() / 8.0f), 0.0);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        PitKilnBlockEntity kiln;
        BlockEntity blockEntity;
        if (facing == Direction.DOWN && !facingState.isFaceSturdy((BlockGetter)level, facingPos, Direction.UP)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.UP && facingState.getBlock() == Blocks.FIRE && (blockEntity = level.getBlockEntity(currentPos)) instanceof PitKilnBlockEntity && !(kiln = (PitKilnBlockEntity)blockEntity).isLit()) {
            level.setBlock(facingPos, Blocks.AIR.defaultBlockState(), 3);
            if (kiln.tryLight()) {
                return (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(16));
            }
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && (blockEntity = level.getBlockEntity(pos)) instanceof PitKilnBlockEntity) {
            int strawValue;
            PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
            ItemStack held = player.getItemInHand(hand);
            Item item = held.getItem();
            int stage = (Integer)state.getValue((Property)STAGE);
            if (stage <= 7 - (strawValue = PitKilnBlock.strawValue(item)) && (Helpers.isItem(item, TFCTags.Items.PIT_KILN_STRAW) || Helpers.isItem(item, TFCTags.Items.PIT_KILN_4_STRAW))) {
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + strawValue)), 10);
                kiln.addStraw(held.split(1), stage + strawValue);
                Helpers.playPlaceSound(null, (LevelAccessor)level, pos, SoundType.GRASS);
            } else if (stage >= 7 && stage < 15 && Helpers.isItem(item, TFCTags.Items.PIT_KILN_LOGS)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 10);
                kiln.addLog(held.split(1), stage - 8 + 1);
                Helpers.playPlaceSound(null, (LevelAccessor)level, pos, SoundType.WOOD);
            } else if (held.isEmpty() && stage != 16) {
                int stagesToRemove;
                ItemStack dropStack;
                NonNullList<ItemStack> logItems = kiln.getLogs();
                NonNullList<ItemStack> strawItems = kiln.getStraws();
                if (stage >= 8) {
                    dropStack = ((ItemStack)logItems.get(stage - 8)).copy();
                    kiln.deleteLog(stage - 8);
                    stagesToRemove = 1;
                } else {
                    dropStack = ((ItemStack)strawItems.get(stage)).copy();
                    kiln.deleteStraw(stage);
                    stagesToRemove = PitKilnBlock.strawValue(dropStack);
                }
                if (!dropStack.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)dropStack);
                }
                if (stage == stagesToRemove - 1) {
                    PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos, false);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage - stagesToRemove)), 10);
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)STAGE)];
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)blockstate.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter levle, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)STAGE)];
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)STAGE)];
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)STAGE)];
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader level, BlockPos pos, Player player) {
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof PitKilnBlockEntity) {
                PitKilnBlockEntity placedItem = (PitKilnBlockEntity)blockEntity;
                return placedItem.getCloneItemStack(state, blockResult);
            }
        }
        return ItemStack.EMPTY;
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)STAGE) == 16 ? 0.0f : super.getDestroyProgress(state, player, level, pos);
    }

    public static int strawValue(ItemStack stack) {
        return stack.getCount() * PitKilnBlock.strawValue(stack.getItem());
    }

    public static int strawValue(Item item) {
        return Helpers.isItem(item, TFCTags.Items.PIT_KILN_4_STRAW) ? 4 : (Helpers.isItem(item, TFCTags.Items.PIT_KILN_STRAW) ? 1 : 0);
    }
}

