/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCDamageTypes;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PotBlock
extends FirepitBlock {
    private static final VoxelShape POT_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)PotBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));

    public PotBlock(ExtendedProperties properties) {
        super(properties, POT_SHAPE);
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POT.get()).ifPresent(pot -> {
            if (!pot.shouldRenderAsBoiling()) {
                return;
            }
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            for (int i = 0; i < random.nextInt(5) + 4; ++i) {
                level.addParticle((ParticleOptions)TFCParticles.BUBBLE.get(), false, x + (double)random.nextFloat() * 0.375 - 0.1875, y + 0.625, z + (double)random.nextFloat() * 0.375 - 0.1875, 0.0, 0.05, 0.0);
            }
            level.addParticle((ParticleOptions)TFCParticles.STEAM.get(), false, x, y + 0.8, z, (double)Helpers.triangle(random), 0.5, (double)Helpers.triangle(random));
            level.playLocalSound(x, y, z, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.7f + 0.4f, false);
        });
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        PotBlockEntity pot = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POT.get()).orElse(null);
        if (pot != null) {
            ItemInteractionResult interactResult;
            if (!pot.isBoiling() && stack.isEmpty() && player.isShiftKeyDown()) {
                if (!(((Boolean)state.getValue((Property)LIT)).booleanValue() || pot.isBoiling() || ((Boolean)state.getValue((Property)LIT)).booleanValue() || pot.getAsh() <= 0)) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), pot.getAsh()));
                    pot.setAsh(0);
                    Helpers.playSound(level, pos, SoundEvents.SAND_BREAK);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POT.get()));
                AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, pot, (Block)TFCBlocks.FIREPIT.get());
                if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                    TFCDamageTypes.pot((Entity)player, 1.0f);
                    Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!pot.isBoiling() && FluidHelpers.transferBetweenBlockEntityAndItem(stack, pot, player, hand)) {
                pot.setAndUpdateSlots(-1);
                pot.markForSync();
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!pot.isBoiling() && (interactResult = pot.interactWithOutput(player, stack)) != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                return interactResult;
            }
            if (PotBlock.tryInsertLog(player, stack, pot, hitResult.getLocation().y - (double)pos.getY() < 0.6)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)pot, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public double getParticleHeightOffset() {
        return 0.8;
    }
}

