/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class QuernBlock
extends DeviceBlock
implements IHighlightHandler {
    private static final VoxelShape BASE_SHAPE = QuernBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final AABB BASE_AABB = BASE_SHAPE.bounds().inflate(0.01);
    private static final VoxelShape HANDSTONE_SHAPE = QuernBlock.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)13.76, (double)13.0);
    private static final AABB HANDSTONE_AABB = HANDSTONE_SHAPE.bounds().inflate(0.01);
    private static final Vec3 HANDSTONE_CENTER = HANDSTONE_SHAPE.bounds().getCenter();
    private static final VoxelShape HANDLE_SHAPE = QuernBlock.box((double)4.34, (double)13.76, (double)4.34, (double)5.36, (double)16.24, (double)5.36);
    private static final AABB HANDLE_AABB = HANDLE_SHAPE.bounds().inflate(0.01);
    private static final VoxelShape INPUT_SLOT_SHAPE = QuernBlock.box((double)6.0, (double)13.76, (double)6.0, (double)10.0, (double)16.24, (double)10.0);
    private static final AABB INPUT_SLOT_AABB = INPUT_SLOT_SHAPE.bounds().inflate(0.01);
    private static final VoxelShape FULL_SHAPE = Shapes.join((VoxelShape)Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{HANDSTONE_SHAPE, HANDLE_SHAPE}), (VoxelShape)INPUT_SLOT_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape COLLISION_FULL_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)HANDSTONE_SHAPE);
    public static final BooleanProperty HAS_HANDSTONE = TFCBlockStateProperties.HAS_HANDSTONE;

    private static SelectionPlace getPlayerSelection(BlockGetter level, BlockPos pos, Player player, BlockHitResult result) {
        QuernBlockEntity quern = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.QUERN.get()).orElse(null);
        if (quern != null) {
            Object inventory = quern.getInventory();
            ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
            Vec3 hit = result.getLocation();
            if (quern.hasHandstone()) {
                if (!quern.isGrinding() && HANDLE_AABB.move(pos).contains(hit)) {
                    return SelectionPlace.HANDLE;
                }
                if (!quern.isGrinding() && !held.isEmpty() || !inventory.getStackInSlot(1).isEmpty() && INPUT_SLOT_AABB.move(pos).contains(hit)) {
                    return SelectionPlace.INPUT_SLOT;
                }
            }
            if ((quern.hasHandstone() || quern.isItemValid(0, held)) && HANDSTONE_AABB.move(pos).contains(hit)) {
                return SelectionPlace.HANDSTONE;
            }
        }
        return SelectionPlace.BASE;
    }

    private static ItemInteractionResult insertOrExtract(Level level, QuernBlockEntity quern, IItemHandler inventory, Player player, ItemStack stack, int slot) {
        if (!stack.isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, inventory.insertItem(slot, stack, false));
        } else {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inventory.extractItem(slot, inventory.getStackInSlot(slot).getCount(), false));
            if (slot == 0) {
                QuernBlock.insertOrExtract(level, quern, inventory, player, ItemStack.EMPTY, 1);
            }
        }
        quern.setAndUpdateSlots(slot);
        quern.markForSync();
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public QuernBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HAS_HANDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HAS_HANDSTONE}));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        QuernBlockEntity quern;
        float rotationSpeed;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof QuernBlockEntity && (rotationSpeed = (quern = (QuernBlockEntity)blockEntity).getRotationSpeed()) != 0.0f && HANDSTONE_AABB.move(pos).contains(entity.position()) && !BASE_AABB.contains(entity.position())) {
            Helpers.rotateEntity(level, entity, HANDSTONE_CENTER.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), -rotationSpeed * 57.295776f);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        QuernBlockEntity quern = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.QUERN.get()).orElse(null);
        if (quern != null && !quern.isGrinding()) {
            Object inventory = quern.getInventory();
            ItemStack heldStack = player.getItemInHand(hand);
            SelectionPlace selection = QuernBlock.getPlayerSelection((BlockGetter)level, pos, player, hitResult);
            return switch (selection.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.attemptGrind(level, pos, quern);
                case 2 -> QuernBlock.insertOrExtract(level, quern, inventory, player, heldStack, 1);
                case 1 -> {
                    if (player.isShiftKeyDown() || Helpers.isItem(heldStack, TFCTags.Items.QUERN_HANDSTONES)) {
                        yield QuernBlock.insertOrExtract(level, quern, inventory, player, heldStack, 0);
                    }
                    yield this.attemptGrind(level, pos, quern);
                }
                case 3 -> QuernBlock.insertOrExtract(level, quern, inventory, player, ItemStack.EMPTY, 2);
            };
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult attemptGrind(Level level, BlockPos pos, QuernBlockEntity quern) {
        return !quern.isConnectedToNetwork() && quern.startGrinding() ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.FAIL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_HANDSTONE) != false ? FULL_SHAPE : BASE_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_HANDSTONE) != false ? COLLISION_FULL_SHAPE : BASE_SHAPE;
    }

    @Override
    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack poseStack, MultiBufferSource buffers, Vec3 renderPos) {
        SelectionPlace selection = QuernBlock.getPlayerSelection((BlockGetter)level, pos, player, rayTrace);
        if (selection != SelectionPlace.BASE) {
            IHighlightHandler.drawBox(poseStack, selection.shape, buffers, pos, renderPos, 1.0f, 0.0f, 0.0f, 0.4f);
            return true;
        }
        return false;
    }

    private static enum SelectionPlace {
        HANDLE(HANDLE_SHAPE),
        HANDSTONE(HANDSTONE_SHAPE),
        INPUT_SLOT(INPUT_SLOT_SHAPE),
        BASE(BASE_SHAPE);

        final VoxelShape shape;

        private SelectionPlace(VoxelShape shape) {
            this.shape = shape;
        }
    }
}

