/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ScrapingBlock
extends DeviceBlock {
    private static final VoxelShape SHAPE = ScrapingBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final Vec3 PLANE_NORMAL = new Vec3(0.0, 1.0, 0.0);
    public static final BooleanProperty WAXED = TFCBlockStateProperties.WAXED;

    private static Vec3 calculatePoint(Vec3 rayVector, Vec3 rayPoint) {
        return rayPoint.subtract(rayVector.scale(rayPoint.dot(PLANE_NORMAL) / rayVector.dot(PLANE_NORMAL)));
    }

    public ScrapingBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !Helpers.isBlock(facingState, TFCTags.Blocks.SCRAPING_SURFACE)) {
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Helpers.isItem(stack, TFCTags.Items.SCRAPING_WAXES) && !((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(true)));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ScrapingBlockEntity) {
            ScrapingBlockEntity scraping = (ScrapingBlockEntity)blockEntity;
            Vec3 point = ScrapingBlock.calculatePoint(player.getLookAngle(), hitResult.getLocation().subtract(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())));
            if (((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
                DyeColor color = DyeColor.getColor((ItemStack)stack);
                if (color != null && scraping.dye(color)) {
                    ScrapingBlock.doParticles(level, pos, scraping, point);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (Helpers.isItem(stack.getItem(), TFCTags.Items.TOOLS_KNIFE)) {
                scraping.onClicked((float)point.x, (float)point.z);
                Helpers.damageItem(stack, (LivingEntity)player, hand);
                ScrapingBlock.doParticles(level, pos, scraping, point);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void doParticles(Level level, BlockPos pos, ScrapingBlockEntity scraping, Vec3 point) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, ((ItemStackHandler)scraping.getInventory()).getStackInSlot(0)), (double)pos.getX() + point.x, (double)pos.getY() + 0.0625, (double)pos.getZ() + point.z, 2, (double)Helpers.triangle(level.random) / 2.0, level.random.nextDouble() / 4.0, (double)Helpers.triangle(level.random) / 2.0, (double)0.15f);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{WAXED}));
    }
}

