/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Locale;
import java.util.function.Consumer;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCComposterBlock
extends BottomSupportedDeviceBlock
implements EntityBlockExtension,
HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_8;
    public static final EnumProperty<CompostType> TYPE = TFCBlockStateProperties.COMPOST_TYPE;
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[9], shapes -> {
        for (int i = 0; i < 9; ++i) {
            shapes[i] = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)Math.max(2, i * 2), (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
        }
    });

    public TFCComposterBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue(TYPE, (Comparable)((Object)CompostType.NORMAL)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.COMPOSTER.get()).map(composter -> composter.use(player.getItemInHand(hand), player, level.isClientSide)).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.COMPOSTER.get()).ifPresent(ComposterBlockEntity::randomTick);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        CompostType type = (CompostType)((Object)state.getValue(TYPE));
        if (type == CompostType.NORMAL) {
            return;
        }
        SimpleParticleType particle = type == CompostType.READY ? ((SimpleParticleType)TFCParticles.COMPOST_READY.get()).getType() : ((SimpleParticleType)TFCParticles.COMPOST_ROTTEN.get()).getType();
        double x = (double)pos.getX() + random.nextDouble();
        double y = (double)(pos.getY() + 1) + random.nextDouble() / 5.0;
        double z = (double)pos.getZ() + random.nextDouble();
        int count = Mth.nextInt((RandomSource)random, (int)0, (int)4);
        for (int i = 0; i < count; ++i) {
            level.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)STAGE)];
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComposterBlockEntity) {
            ComposterBlockEntity composter = (ComposterBlockEntity)blockEntity;
            text.accept((Component)Component.translatable((String)"tfc.composter.green_items", (Object[])new Object[]{composter.getGreen()}).withStyle(ChatFormatting.GREEN));
            text.accept((Component)Component.translatable((String)"tfc.composter.brown_items", (Object[])new Object[]{composter.getBrown()}).withStyle(ChatFormatting.GOLD));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{STAGE, TYPE}));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComposterBlockEntity) {
            ComposterBlockEntity composter = (ComposterBlockEntity)blockEntity;
            composter.resetCounter();
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue(TYPE) != CompostType.ROTTEN;
    }

    public static enum CompostType implements StringRepresentable
    {
        NORMAL,
        READY,
        ROTTEN;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

