/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.ThermometerBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThermometerBlock
extends DeviceBlock {
    public static IntegerProperty POWER = BlockStateProperties.POWER;
    public static BooleanProperty ATTACHED = TFCBlockStateProperties.THERMOMETER_ATTACHED;
    public static DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_NORTH = ThermometerBlock.box((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = ThermometerBlock.box((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPE_EAST = ThermometerBlock.box((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)15.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = ThermometerBlock.box((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0);

    public ThermometerBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ATTACHED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] looking;
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : looking = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            if (levelreader.getBlockState(blockpos.relative(direction1.getOpposite())).is(TFCTags.Blocks.THERMOMETER_READABLE)) {
                blockstate = (BlockState)blockstate.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
            }
            return blockstate;
        }
        return null;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ThermometerBlockEntity) {
            ThermometerBlockEntity thermometer = (ThermometerBlockEntity)blockEntity;
            thermometer.needsInstantUpdate();
        }
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER}).add(new Property[]{FACING}).add(new Property[]{ATTACHED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.DOWN, Direction.UP -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos blockpos, BlockPos facingPos) {
        if (facing == ((Direction)state.getValue((Property)FACING)).getOpposite() && !this.canSurvive(state, (LevelReader)level, blockpos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, blockpos, facingPos);
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (blockState.getValue((Property)FACING) == side && !((Boolean)blockState.getValue((Property)ATTACHED)).booleanValue()) {
            return this.getSignal(blockState, blockAccess, pos, side);
        }
        return 0;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (Helpers.isBlock(blockState, (Block)TFCBlocks.THERMOMETER.get())) {
            return (Integer)blockState.getValue((Property)POWER);
        }
        return 0;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return ThermometerBlock.canSurvive(level, pos, (Direction)state.getValue((Property)FACING));
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Direction facing) {
        BlockPos blockpos = pos.relative(facing.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        if (blockstate.is((Block)TFCBlocks.CRUCIBLE.get())) {
            return true;
        }
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, facing);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

