/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.blockentities.VaneBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VaneBlock
extends DeviceBlock {
    public static BooleanProperty ATTACHED_WIND_DEVICES = TFCBlockStateProperties.ATTACHED_WIND_DEVICES;
    private static final VoxelShape SHAPE = VaneBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    private static final VoxelShape SHAPE_ATTACHED = VaneBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public VaneBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHED_WIND_DEVICES, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        return context.getLevel().getBlockState(blockpos.below()).is((Block)TFCBlocks.ANEMOMETER.get()) ? (BlockState)this.defaultBlockState().setValue((Property)ATTACHED_WIND_DEVICES, (Comparable)Boolean.valueOf(true)) : this.defaultBlockState();
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos blockpos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            if (!this.canSurvive(state, (LevelReader)level, blockpos)) {
                return Blocks.AIR.defaultBlockState();
            }
            return level.getBlockState(blockpos.below()).is((Block)TFCBlocks.ANEMOMETER.get()) ? (BlockState)this.defaultBlockState().setValue((Property)ATTACHED_WIND_DEVICES, (Comparable)Boolean.valueOf(true)) : this.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, blockpos, facingPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)ATTACHED_WIND_DEVICES) != false ? SHAPE_ATTACHED : SHAPE;
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        level.updateNeighborsAt(pos.below(), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ATTACHED_WIND_DEVICES});
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side == Direction.UP) {
            return this.getSignal(blockState, blockAccess, pos, side);
        }
        return 0;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (blockEntity instanceof VaneBlockEntity) {
            VaneBlockEntity vane = (VaneBlockEntity)blockEntity;
            return vane.getRedstoneSignal();
        }
        return 0;
    }

    protected boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (levelReader.getBlockState(pos.below()).is((Block)TFCBlocks.ANEMOMETER.get())) {
            return true;
        }
        return VaneBlock.canSupportCenter((LevelReader)levelReader, (BlockPos)pos.below(), (Direction)Direction.UP);
    }
}

